/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.dev.profiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import redempt.redlib.RedLib;
import redempt.redlib.dev.profiler.BurstProfiler;
import redempt.redlib.dev.profiler.SampleSummary;
import redempt.redlib.misc.Task;

public class TickMonitorProfiler {
    private static int tick = -1;
    private static Deque<Long> times = new ArrayDeque<Long>();
    private static BurstProfiler burst;
    private static List<SampleSummary> reports;
    private static long tickMinimum;
    private static Task task;

    public static void setTickMinimum(long tickMinimum) {
        TickMonitorProfiler.tickMinimum = tickMinimum;
    }

    public static void start() {
        if (tick != -1) {
            return;
        }
        burst = new BurstProfiler(10000);
        burst.start();
        tick = 0;
        task = Task.syncRepeating(RedLib.getInstance(), () -> {
            long time;
            if (times.size() >= 999) {
                times.poll();
            }
            ++tick;
            long current = System.currentTimeMillis();
            if (times.size() > 0 && current - (time = times.getLast().longValue()) >= tickMinimum) {
                SampleSummary summary = burst.getSummary(time);
                if (reports.size() >= 15) {
                    reports.stream().min(Comparator.comparingLong(SampleSummary::getDuration)).ifPresent(s -> reports.remove(s));
                }
                reports.add(summary);
            }
            times.add(current);
        }, 1L, 1L);
    }

    public static void stop() {
        if (task != null) {
            task.cancel();
        }
        tick = -1;
        burst.stop();
    }

    public static void clear() {
        reports.clear();
    }

    public static List<SampleSummary> getReports() {
        return reports;
    }

    static {
        reports = new ArrayList<SampleSummary>(15);
        tickMinimum = 100L;
    }
}

