/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.nms;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import redempt.redlib.nms.NMSClass;
import redempt.redlib.nms.NMSHelper;

public class NMSObject {
    private Object obj;

    public NMSObject(Object obj) {
        this.obj = obj;
    }

    public Object getObject() {
        return this.obj;
    }

    public String getTypeName() {
        return this.obj.getClass().getSimpleName();
    }

    public NMSClass getType() {
        return new NMSClass(this.obj.getClass());
    }

    public boolean isNull() {
        return this.obj == null;
    }

    public NMSObject callMethod(int supers, String name, Object ... args) {
        try {
            Method method = NMSHelper.getMethod(this.getSuperclass(this.obj.getClass(), supers), name, NMSHelper.getArgTypes(args));
            return new NMSObject(method.invoke(this.obj, args));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public NMSObject callMethod(String name, Object ... args) {
        return this.callMethod(0, name, args);
    }

    public NMSObject getField(int supers, String name) {
        try {
            Field field = this.getSuperclass(this.obj.getClass(), supers).getDeclaredField(name);
            field.setAccessible(true);
            return new NMSObject(field.get(this.obj));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public NMSObject getField(String name) {
        return this.getField(0, name);
    }

    public void setField(int supers, String name, Object obj) {
        if (obj instanceof NMSObject) {
            obj = ((NMSObject)obj).getObject();
        }
        try {
            Field field = this.getSuperclass(this.obj.getClass(), supers).getDeclaredField(name);
            field.setAccessible(true);
            field.set(this.obj, obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setField(String name, Object obj) {
        this.setField(0, name, obj);
    }

    private Class<?> getSuperclass(Class<?> clazz, int levels) {
        for (int i = 0; i < levels; ++i) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }
}

