/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import redempt.redlib.misc.EntityPersistor;

public class Hologram {
    private static Objective objective;
    private int id;
    private List<EntityPersistor<ArmorStand>> stands = new ArrayList<EntityPersistor<ArmorStand>>();
    private Location start;
    private double lineSpacing = 0.35;

    public static Hologram create(Location loc, String ... lines) {
        Random random = new Random();
        Hologram hologram = new Hologram(random.nextInt(Integer.MAX_VALUE) + 1, loc.clone());
        for (String line : lines) {
            hologram.append(line);
        }
        return hologram;
    }

    public static Hologram getAt(Location loc) {
        ArrayList<ArmorStand> stands = new ArrayList<ArmorStand>();
        loc.getChunk().load();
        Arrays.stream(loc.getChunk().getEntities()).filter(e -> e instanceof ArmorStand).map(e -> (ArmorStand)e).filter(s -> Hologram.getId(s) != 0).forEach(stands::add);
        if (stands.size() == 0) {
            return null;
        }
        double dist = Double.MAX_VALUE;
        ArmorStand closest = null;
        for (ArmorStand stand : stands) {
            double distance = stand.getLocation().distanceSquared(loc);
            if (!(distance < dist)) continue;
            dist = distance;
            closest = stand;
        }
        if (dist > 0.6) {
            return null;
        }
        int id = Hologram.getId(closest);
        stands.removeIf(s -> Hologram.getId(s) != id);
        stands.sort((a, b) -> (int)Math.signum(b.getLocation().getY() - a.getLocation().getY()));
        Hologram hologram = new Hologram(id, ((ArmorStand)stands.get(0)).getLocation(), stands);
        return hologram;
    }

    private static int getId(ArmorStand stand) {
        return objective.getScore(stand.getUniqueId().toString()).getScore();
    }

    private static void setId(ArmorStand stand, int id) {
        objective.getScore(stand.getUniqueId().toString()).setScore(id);
    }

    private Hologram(int id, Location start) {
        this.id = id;
        this.start = start;
    }

    private Hologram(int id, Location start, List<ArmorStand> stands) {
        this.id = id;
        this.stands.clear();
        stands.stream().map(EntityPersistor::wrap).forEach(this.stands::add);
        this.start = start;
    }

    public void fixStands() {
        if (this.stands.size() == 0) {
            return;
        }
        Location loc = this.start.clone();
        List<String> lines = this.getLines();
        this.clear();
        for (int i = 0; i < lines.size(); ++i) {
            this.append(lines.get(i));
        }
    }

    public String getLine(int line) {
        return this.stands.get(line).get().getCustomName();
    }

    public void move(Location loc) {
        this.start = loc.clone();
        this.fixStands();
    }

    public Location getLocation() {
        return this.start;
    }

    public List<ArmorStand> getStands() {
        return this.stands.stream().map(EntityPersistor::get).collect(Collectors.toList());
    }

    public void setLine(int line, String text) {
        this.stands.get(line).get().setCustomName(text);
    }

    public void remove(int line) {
        ArmorStand stand = this.stands.remove(line).get();
        stand.remove();
        this.fixStands();
    }

    public void clear() {
        this.stands.forEach(s -> ((ArmorStand)s.get()).remove());
        this.stands.clear();
    }

    public double getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(double lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.fixStands();
    }

    public void append(String text) {
        ArmorStand stand = this.spawn(this.stands.size(), text);
        this.stands.add(EntityPersistor.wrap(stand));
    }

    public void prepend(String text) {
        this.insert(0, text);
    }

    public void insert(int line, String text) {
        ArmorStand stand = this.spawn(line, text);
        this.stands.add(line, EntityPersistor.wrap(stand));
        this.fixStands();
    }

    public int size() {
        return this.stands.size();
    }

    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (ArmorStand stand : this.getStands()) {
            lines.add(stand.getCustomName());
        }
        return lines;
    }

    private ArmorStand spawn(int line, String text) {
        Location loc;
        if (this.stands.size() > 0) {
            loc = this.stands.get(0).get().getLocation();
            loc.subtract(0.0, this.lineSpacing * (double)line, 0.0);
        } else {
            loc = this.start;
        }
        ArmorStand stand = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
        this.initiate(stand, text);
        return stand;
    }

    private void initiate(ArmorStand stand, String text) {
        stand.setCustomName(text);
        stand.setCustomNameVisible(true);
        stand.setVisible(false);
        stand.setGravity(false);
        stand.setMarker(true);
        Hologram.setId(stand, this.id);
    }

    static {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        objective = scoreboard.getObjective("hologramID");
        if (objective == null) {
            objective = scoreboard.registerNewObjective("hologramID", "dummy");
        }
    }
}

