/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.util.Vector;
import redempt.redlib.misc.LocationUtils;
import redempt.redlib.multiblock.Rotator;
import redempt.redlib.region.MultiRegion;
import redempt.redlib.region.Overlappable;
import redempt.redlib.region.Region;

public class CuboidRegion
extends Overlappable {
    protected Location start;
    protected Location end;

    public static CuboidRegion cubeRadius(Location loc, int radius) {
        return new CuboidRegion(loc.clone().subtract((double)radius, (double)radius, (double)radius), loc.clone().add((double)(radius + 1), (double)(radius + 1), (double)(radius + 1)));
    }

    public CuboidRegion(Location start, Location end) {
        this.setLocations(start, end);
    }

    protected CuboidRegion() {
    }

    protected void setLocations(Location start, Location end) {
        if (!start.getWorld().equals((Object)end.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world");
        }
        double minX = Math.min(start.getX(), end.getX());
        double minY = Math.min(start.getY(), end.getY());
        double minZ = Math.min(start.getZ(), end.getZ());
        double maxX = Math.max(start.getX(), end.getX());
        double maxY = Math.max(start.getY(), end.getY());
        double maxZ = Math.max(start.getZ(), end.getZ());
        this.start = new Location(start.getWorld(), minX, minY, minZ);
        this.end = new Location(end.getWorld(), maxX, maxY, maxZ);
    }

    @Override
    public Location getStart() {
        return this.start.clone();
    }

    @Override
    public Location getEnd() {
        return this.end.clone();
    }

    @Override
    public boolean contains(Location loc) {
        return loc.getWorld().getName().equals(this.start.getWorld().getName()) && loc.getX() >= this.start.getX() && loc.getY() >= this.start.getY() && loc.getZ() >= this.start.getZ() && loc.getX() < this.end.getX() && loc.getY() < this.end.getY() && loc.getZ() < this.end.getZ();
    }

    @Override
    public double getVolume() {
        double[] dim = this.getDimensions();
        return dim[0] * dim[1] * dim[2];
    }

    @Override
    public int getBlockVolume() {
        int[] dim = this.getBlockDimensions();
        return dim[0] * dim[1] * dim[2];
    }

    public RegionState getState() {
        return new RegionState(this);
    }

    @Override
    public CuboidRegion clone() {
        return new CuboidRegion(this.start.clone(), this.end.clone());
    }

    public CuboidRegion expand(double amount) {
        this.expand(amount, amount, amount, amount, amount, amount);
        return this;
    }

    @Override
    public CuboidRegion expand(double posX, double negX, double posY, double negY, double posZ, double negZ) {
        this.start = this.start.subtract(negX, negY, negZ);
        this.end = this.end.add(posX, posY, posZ);
        this.setLocations(this.start, this.end);
        return this;
    }

    @Override
    public CuboidRegion expand(BlockFace direction, double amount) {
        Vector vec = LocationUtils.getDirection(direction);
        if (vec.getX() + vec.getY() + vec.getZ() > 0.0) {
            vec = vec.multiply(amount);
            this.end = this.end.add(vec);
        } else {
            vec = vec.multiply(amount);
            this.start = this.start.add(vec);
        }
        this.setLocations(this.start, this.end);
        return this;
    }

    @Override
    public CuboidRegion move(Vector v) {
        this.start = this.start.add(v);
        this.end = this.end.add(v);
        return this;
    }

    @Override
    public CuboidRegion move(double x, double y, double z) {
        return this.move(new Vector(x, y, z));
    }

    @Override
    public CuboidRegion setWorld(World world) {
        this.start.setWorld(world);
        this.end.setWorld(world);
        return this;
    }

    public boolean isMulti() {
        return false;
    }

    @Override
    public void forEachBlock(Consumer<Block> lambda) {
        this.stream().forEach(lambda);
    }

    @Override
    public World getWorld() {
        return this.start.getWorld();
    }

    @Override
    public boolean overlaps(Overlappable overlap) {
        Overlappable o = overlap;
        if (!o.getWorld().equals((Object)this.getWorld())) {
            return false;
        }
        if (o instanceof MultiRegion) {
            MultiRegion multi = (MultiRegion)o;
            return multi.getRegions().stream().anyMatch(r -> overlap.overlaps(this));
        }
        return !(this.start.getX() >= o.getEnd().getX() || o.getStart().getX() >= this.end.getX() || this.start.getY() >= o.getEnd().getY() || o.getStart().getY() >= this.end.getY() || this.start.getZ() >= o.getEnd().getZ() || o.getStart().getZ() >= this.end.getZ());
    }

    @Override
    public CuboidRegion rotate(Location center, int rotations) {
        Location start = this.getStart();
        Location end = this.getEnd();
        start.subtract(center);
        end.subtract(center);
        Rotator rotator = new Rotator(rotations, false);
        rotator.setLocation(start.getX(), start.getZ());
        start.setX(rotator.getRotatedX());
        start.setZ(rotator.getRotatedZ());
        rotator.setLocation(end.getX(), end.getZ());
        end.setX(rotator.getRotatedX());
        end.setZ(rotator.getRotatedZ());
        start.add(center);
        end.add(center);
        this.setLocations(start, end);
        return this;
    }

    public CuboidRegion rotate(int rotations) {
        this.rotate(this.getCenter(), rotations);
        return this;
    }

    @Override
    public Region getIntersection(Overlappable overlap) {
        Overlappable o = overlap;
        if (o instanceof MultiRegion) {
            return overlap.getIntersection(this);
        }
        if (!this.overlaps(overlap)) {
            return null;
        }
        double minX = Math.max(o.getStart().getX(), this.start.getX());
        double minY = Math.max(o.getStart().getY(), this.start.getY());
        double minZ = Math.max(o.getStart().getZ(), this.start.getZ());
        double maxX = Math.min(o.getEnd().getX(), this.end.getX());
        double maxY = Math.min(o.getEnd().getY(), this.end.getY());
        double maxZ = Math.min(o.getEnd().getZ(), this.end.getZ());
        return new CuboidRegion(new Location(this.getWorld(), minX, minY, minZ), new Location(this.getWorld(), maxX, maxY, maxZ));
    }

    @Override
    public Stream<Block> stream() {
        int[] dimensions = this.getBlockDimensions();
        RegionIterator iterator = new RegionIterator(dimensions[0], dimensions[1], dimensions[2]);
        Stream<Block> stream = Stream.generate(() -> {
            int[] pos = iterator.getPosition();
            Block block = this.start.clone().add((double)pos[0], (double)pos[1], (double)pos[2]).getBlock();
            iterator.next();
            return block;
        });
        return ((Stream)stream.sequential()).limit(this.getBlockVolume());
    }

    public CuboidRegion getFace(BlockFace face) {
        CuboidRegion region = this.clone();
        region.expand(face.getOppositeFace(), -region.measure(face) + 1.0);
        return region;
    }

    public String toString() {
        return this.getWorld().getName() + " " + this.start.getX() + " " + this.start.getY() + " " + this.start.getZ() + " " + this.end.getX() + " " + this.end.getY() + " " + this.end.getZ();
    }

    public static CuboidRegion fromString(String input) {
        String[] split = input.split(" ");
        World world = Bukkit.getWorld((String)split[0]);
        double minX = Double.parseDouble(split[1]);
        double minY = Double.parseDouble(split[2]);
        double minZ = Double.parseDouble(split[3]);
        double maxX = Double.parseDouble(split[4]);
        double maxY = Double.parseDouble(split[5]);
        double maxZ = Double.parseDouble(split[6]);
        return new CuboidRegion(new Location(world, minX, minY, minZ), new Location(world, maxX, maxY, maxZ));
    }

    public static class RegionState {
        BlockState[][][] blocks;
        private CuboidRegion region;

        private RegionState(CuboidRegion region) {
            this.region = region;
            int[] dimensions = region.getBlockDimensions();
            this.blocks = new BlockState[dimensions[0]][dimensions[1]][dimensions[2]];
            for (int x = 0; x < dimensions[0]; ++x) {
                for (int y = 0; y < dimensions[1]; ++y) {
                    for (int z = 0; z < dimensions[2]; ++z) {
                        Location loc = region.getStart().add((double)x, (double)y, (double)z);
                        this.blocks[x][y][z] = loc.getBlock().getState();
                    }
                }
            }
        }

        public void restore() {
            int[] dimensions = this.region.getBlockDimensions();
            for (int x = 0; x < dimensions[0]; ++x) {
                for (int y = 0; y < dimensions[1]; ++y) {
                    for (int z = 0; z < dimensions[2]; ++z) {
                        this.blocks[x][y][z].update(true, false);
                    }
                }
            }
        }

        public BlockState[][][] getBlocks() {
            return (BlockState[][][])this.blocks.clone();
        }
    }

    private static class RegionIterator {
        private int maxX;
        private int maxY;
        private int maxZ;
        private int x = 0;
        private int y = 0;
        private int z = 0;

        public RegionIterator(int x, int y, int z) {
            this.maxX = x;
            this.maxY = y;
            this.maxZ = z;
        }

        public int[] getPosition() {
            return new int[]{this.x, this.y, this.z};
        }

        public boolean next() {
            ++this.x;
            if (this.x >= this.maxX) {
                this.x = 0;
                ++this.y;
                if (this.y >= this.maxY) {
                    this.y = 0;
                    ++this.z;
                    if (this.z >= this.maxZ) {
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

