/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.json;

import redempt.redlib.json.JSONList;
import redempt.redlib.json.JSONMap;
import redempt.redlib.json.JSONStorage;

public class JSONParser {
    public static JSONList parseList(String json) {
        return (JSONList)JSONParser.parse(json);
    }

    public static JSONMap parseMap(String json) {
        return (JSONMap)JSONParser.parse(json);
    }

    private static JSONStorage parse(String json) {
        Type parentType;
        switch (json.charAt(0)) {
            case '[': {
                parentType = Type.LIST;
                break;
            }
            case '{': {
                parentType = Type.MAP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid JSON input");
            }
        }
        boolean quoted = false;
        Object currentParent = parentType == Type.LIST ? new JSONList() : new JSONMap();
        Cloneable root = currentParent;
        int cursor = 1;
        int lastChar = -1;
        boolean end = false;
        String key = null;
        Type type = Type.INT;
        char[] chars = json.toCharArray();
        block26: for (int i = 1; i < json.length(); ++i) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (quoted || lastChar != -1) continue block26;
                    cursor = i + 1;
                    continue block26;
                }
                case '\\': {
                    lastChar = ++i;
                    continue block26;
                }
                case 'n': {
                    if (!quoted) {
                        type = Type.NULL;
                    }
                    lastChar = i;
                    continue block26;
                }
                case '\"': {
                    quoted = !quoted;
                    lastChar = i;
                    type = Type.STRING;
                    continue block26;
                }
                case '.': {
                    if (!quoted) {
                        type = Type.DOUBLE;
                    }
                    lastChar = i;
                    continue block26;
                }
                case 'f': 
                case 't': {
                    if (quoted) continue block26;
                    type = Type.BOOLEAN;
                    continue block26;
                }
                case ':': {
                    if (quoted) continue block26;
                    key = json.substring(cursor + 1, lastChar);
                    type = Type.INT;
                    cursor = i + 1;
                    lastChar = -1;
                    continue block26;
                }
                case ']': 
                case '}': {
                    if (quoted) continue block26;
                    end = true;
                }
                case ',': {
                    if (quoted) continue block26;
                    if (lastChar != -1) {
                        Object value = null;
                        switch (type) {
                            case STRING: {
                                value = JSONParser.substring(chars, cursor + 1, lastChar);
                                break;
                            }
                            case INT: {
                                value = JSONParser.parseInteger(json.substring(cursor, lastChar + 1));
                                break;
                            }
                            case DOUBLE: {
                                value = JSONParser.parseDouble(json.substring(cursor, lastChar + 1));
                                break;
                            }
                            case BOOLEAN: {
                                value = chars[cursor] == 't';
                                break;
                            }
                            case NULL: {
                                value = null;
                            }
                        }
                        currentParent.add(key, value);
                        key = null;
                    } else {
                        switch (chars[i]) {
                            case ']': 
                            case '}': {
                                end = true;
                                break;
                            }
                            default: {
                                end = false;
                            }
                        }
                    }
                    type = Type.INT;
                    if (end) {
                        Cloneable prev = currentParent;
                        Type type2 = parentType = (currentParent = currentParent.getParent()) instanceof JSONList ? Type.LIST : Type.MAP;
                        if (currentParent != null && currentParent.getTempKey() != null) {
                            currentParent.add(currentParent.getTempKey(), prev);
                            currentParent.setTempKey(null);
                        }
                    }
                    lastChar = -1;
                    cursor = i + 1;
                    end = false;
                    continue block26;
                }
                case '[': 
                case '{': {
                    if (quoted) continue block26;
                    currentParent.setTempKey(key == null ? "" : key);
                    key = null;
                    Cloneable next = chars[i] == '[' ? new JSONList() : new JSONMap();
                    next.setParent((JSONStorage)currentParent);
                    currentParent = next;
                    cursor = i + 1;
                    lastChar = -1;
                    continue block26;
                }
                default: {
                    lastChar = i;
                }
            }
        }
        return root;
    }

    private static double parseDouble(String input) {
        int i = 0;
        boolean negative = false;
        if (input.charAt(0) == '-') {
            negative = true;
            ++i;
        }
        double output = 0.0;
        double after = 0.0;
        int decimal = -1;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '.') {
                if (decimal != -1) {
                    throw new NumberFormatException("Second period in double");
                }
                decimal = i;
            } else {
                if (c > '9' || c < '0') {
                    throw new NumberFormatException("Non-numeric character");
                }
                if (decimal != -1) {
                    after *= 10.0;
                    after += (double)(c - 48);
                } else {
                    output *= 10.0;
                    output += (double)(c - 48);
                }
            }
            ++i;
        }
        return negative ? -output - after : output + (after /= Math.pow(10.0, input.length() - decimal - 1));
    }

    private static Object parseInteger(String input) {
        int i = 0;
        boolean negative = false;
        if (input.charAt(0) == '-') {
            negative = true;
            ++i;
        }
        long output = 0L;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c != 'L') {
                if (c > '9' || c < '0') {
                    throw new NumberFormatException("Non-numeric character");
                }
                output *= 10L;
                output += (long)(c - 48);
            }
            ++i;
        }
        long l = output = negative ? -output : output;
        if (output > Integer.MAX_VALUE || output < Integer.MIN_VALUE) {
            return output;
        }
        return (int)output;
    }

    private static String substring(char[] chars, int start, int end) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c == '\\') {
                builder.append(chars[i + 1]);
                ++i;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static enum Type {
        LIST,
        MAP,
        STRING,
        BOOLEAN,
        DOUBLE,
        INT,
        NULL;

    }
}

