/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.inventorygui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemStack;
import redempt.redlib.inventorygui.InventoryGUI;
import redempt.redlib.inventorygui.ItemButton;

public class PaginationPanel {
    private InventoryGUI gui;
    private int page = 1;
    private List<IntConsumer> buttons = new ArrayList<IntConsumer>();
    private Map<Object, IntConsumer> items = new HashMap<Object, IntConsumer>();
    private Set<Integer> slots = new TreeSet<Integer>();
    private Runnable onUpdate = () -> {};

    public PaginationPanel(InventoryGUI gui) {
        this.gui = gui;
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }

    private void addPagedButton0(ItemButton button) {
        IntConsumer setter = i -> this.gui.addButton(button, i);
        this.items.put(button, setter);
        this.buttons.add(setter);
    }

    public void addPagedButton(ItemButton button) {
        this.addPagedButton0(button);
        this.updatePage();
    }

    private void addPagedItem0(ItemStack item) {
        IntConsumer setter = i -> this.gui.getInventory().setItem(i, item);
        this.items.put(item, setter);
        this.buttons.add(setter);
    }

    public void addPagedItem(ItemStack item) {
        this.addPagedItem0(item);
        this.updatePage();
    }

    public void addPagedButtons(Iterable<ItemButton> buttons) {
        for (ItemButton button : buttons) {
            this.addPagedButton0(button);
        }
        this.updatePage();
    }

    public void addPagedItems(Iterable<ItemStack> items) {
        for (ItemStack item : items) {
            this.addPagedItem0(item);
        }
        this.updatePage();
    }

    public void removePagedItem(ItemStack item) {
        this.buttons.remove(this.items.remove(item));
        this.updatePage();
    }

    public void removePagedButton(ItemButton button) {
        this.buttons.remove(this.items.remove(button));
        this.updatePage();
    }

    public void removePagedItems(Iterable<ItemStack> items) {
        for (ItemStack item : items) {
            this.buttons.remove(this.items.remove(item));
        }
        this.updatePage();
    }

    public void removePagedButtons(Iterable<ItemButton> buttons) {
        for (ItemButton button : buttons) {
            this.buttons.remove(this.items.remove(button));
        }
        this.updatePage();
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.slots.size();
    }

    public int getMaxPage() {
        return Math.max(0, this.buttons.size() - 1) / Math.max(1, this.slots.size()) + 1;
    }

    public void addSlot(int slot) {
        this.slots.add(slot);
        this.updatePage();
    }

    public void addSlots(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.slots.add(i);
        }
        this.updatePage();
    }

    public void addSlots(int x1, int y1, int x2, int y2) {
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                this.slots.add(y * 9 + x);
            }
        }
        this.updatePage();
    }

    public void removeSlot(int slot) {
        this.slots.forEach(this.gui::clearSlot);
        this.slots.remove(slot);
        this.updatePage();
    }

    public void removeSlots(int start, int end) {
        this.slots.forEach(this.gui::clearSlot);
        for (int i = start; i < end; ++i) {
            this.slots.remove(i);
        }
        this.updatePage();
    }

    public void removeSlots(int x1, int y1, int x2, int y2) {
        this.slots.forEach(this.gui::clearSlot);
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                this.slots.remove(y * 9 + x);
            }
        }
        this.updatePage();
    }

    public void updatePage() {
        this.slots.forEach(this.gui::clearSlot);
        if (this.getPageSize() == 0 || this.buttons.size() == 0) {
            this.onUpdate.run();
            return;
        }
        int start = (this.page - 1) * this.getPageSize();
        int end = Math.min(this.buttons.size(), this.page * this.getPageSize());
        Iterator<Integer> iter = this.slots.iterator();
        for (int i = start; i < end; ++i) {
            this.buttons.get(i).accept(iter.next());
        }
        this.onUpdate.run();
    }

    public void setPage(int page) {
        if (page < 1 || page > this.getMaxPage()) {
            throw new IllegalArgumentException("Invalid page: " + page);
        }
        this.page = page;
        this.updatePage();
    }

    public void clear() {
        this.buttons.clear();
        this.items.clear();
        this.updatePage();
    }

    public List<ItemStack> getItems() {
        return this.items.keySet().stream().filter(ItemStack.class::isInstance).map(ItemStack.class::cast).collect(Collectors.toList());
    }

    public List<ItemButton> getButtons() {
        return this.items.keySet().stream().filter(ItemButton.class::isInstance).map(ItemButton.class::cast).collect(Collectors.toList());
    }

    public void nextPage() {
        this.page = Math.min(this.page + 1, this.getMaxPage());
        this.updatePage();
    }

    public void prevPage() {
        this.page = Math.max(1, this.page - 1);
        this.updatePage();
    }
}

