/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.enchants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import redempt.redlib.enchants.EnchantListener;
import redempt.redlib.enchants.EnchantRegistry;
import redempt.redlib.enchants.trigger.EnchantTrigger;

public abstract class CustomEnchant {
    private EnchantRegistry registry;
    private Map<EnchantTrigger<?>, EnchantListener<?>> triggers = new HashMap();
    private int maxLevel;
    private String name;
    private EnumSet<Material> applicable;

    public static String toRomanNumerals(int num) {
        switch (num) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return num + "";
    }

    public static int fromRomanNumerals(String romanNumerals) {
        switch (romanNumerals) {
            case "I": {
                return 1;
            }
            case "II": {
                return 2;
            }
            case "III": {
                return 3;
            }
            case "IV": {
                return 4;
            }
            case "V": {
                return 5;
            }
            case "VI": {
                return 6;
            }
            case "VII": {
                return 7;
            }
            case "VIII": {
                return 8;
            }
            case "IX": {
                return 9;
            }
            case "X": {
                return 10;
            }
        }
        for (char c : romanNumerals.toCharArray()) {
            if (c <= '9' && c >= '0') continue;
            return 0;
        }
        return Integer.parseInt(romanNumerals);
    }

    public CustomEnchant(String name, int maxLevel) {
        if (this.name != null) {
            throw new IllegalStateException("This enchantment has already been instantiated, get it through the EnchantRegistry!");
        }
        this.name = name;
        this.maxLevel = maxLevel;
    }

    protected void register(EnchantRegistry registry) {
        this.registry = registry;
    }

    protected <T extends Event> void addTrigger(EnchantTrigger<T> trigger, BiConsumer<T, Integer> activate, BiConsumer<T, Integer> deactivate) {
        this.triggers.put(trigger, new EnchantListener<T>(activate, deactivate));
    }

    protected <T extends Event> void addTrigger(EnchantTrigger<T> trigger, BiConsumer<T, Integer> activate) {
        this.triggers.put(trigger, new EnchantListener<Event>(activate, (e, l) -> {}));
    }

    public CustomEnchant[] getIncompatible() {
        return new CustomEnchant[0];
    }

    public final Map<EnchantTrigger<?>, EnchantListener<?>> getTriggers() {
        return this.triggers;
    }

    protected boolean appliesTo(Material type) {
        return this.triggers.keySet().stream().anyMatch(t -> t.defaultAppliesTo(type));
    }

    public final String getName() {
        return this.name;
    }

    public final String getId() {
        return this.name.toLowerCase().replace(" ", "_");
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final EnchantRegistry getRegistry() {
        return this.registry;
    }

    public final boolean isRegistered() {
        return this.registry != null;
    }

    public String getDisplayName() {
        return this.registry.getDisplayName(this);
    }

    public ItemStack apply(ItemStack item, int level) {
        if (item == null) {
            return null;
        }
        if (level == 0) {
            return this.remove(item);
        }
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        lore = lore == null ? new ArrayList() : lore;
        int where = -1;
        boolean replace = false;
        String displayName = this.getDisplayName();
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = (String)lore.get(i);
            if (where == -1 && this.registry.fromLoreLine(line) != null) {
                where = i + 1;
            }
            if (!line.startsWith(displayName)) continue;
            replace = true;
            where = i;
            break;
        }
        if (where == -1) {
            where = lore.size();
        }
        if (replace) {
            lore.set(where, this.getLore(level));
        } else {
            lore.add(where, this.getLore(level));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack remove(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return item;
        }
        String displayName = this.getDisplayName();
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        lore.removeIf(s -> s.startsWith(displayName));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public int getLevel(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return 0;
        }
        List lore = item.getItemMeta().getLore();
        String displayName = this.getDisplayName();
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = (String)lore.get(i);
            if (!line.startsWith(displayName)) continue;
            if (line.length() == displayName.length()) {
                return 1;
            }
            return CustomEnchant.fromRomanNumerals(line.substring(displayName.length() + 1));
        }
        return 0;
    }

    public final boolean canApply(ItemStack item) {
        if (!this.canApply(item.getType())) {
            return false;
        }
        Map<CustomEnchant, Integer> enchants = this.registry.getEnchants(item);
        for (CustomEnchant ench : this.getIncompatible()) {
            if (!enchants.containsKey(ench)) continue;
            return false;
        }
        return true;
    }

    public final boolean canApply(Material type) {
        if (this.applicable == null) {
            this.applicable = EnumSet.noneOf(Material.class);
            Arrays.stream(Material.values()).filter(this::appliesTo).forEach(this.applicable::add);
        }
        return this.applicable.contains(type);
    }

    public boolean isCompatible(CustomEnchant ench) {
        return Arrays.stream(this.getIncompatible()).noneMatch(e -> e.equals(ench));
    }

    public String getLore(int level) {
        if (level == 1 && this.maxLevel == 1) {
            return this.getDisplayName();
        }
        return this.getDisplayName() + " " + CustomEnchant.toRomanNumerals(level);
    }
}

