/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.conversion;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import redempt.redlib.config.ConfigManager;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;

public class StaticRootConverter {
    public static <T> TypeConverter<T> create(ConfigManager manager, Class<?> root) {
        final ArrayList<Field> fields = new ArrayList<Field>();
        final HashMap converters = new HashMap();
        for (Field field : root.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isTransient(mod) || !Modifier.isStatic(mod)) continue;
            field.setAccessible(true);
            fields.add(field);
            converters.put(field, manager.getConverter(ConfigType.get(field)));
        }
        return new TypeConverter<T>(){

            @Override
            public T loadFrom(DataHolder section, String path, T currentValue) {
                try {
                    for (Field field : fields) {
                        Object val = ((TypeConverter)converters.get(field)).loadFrom(section, field.getName(), null);
                        field.set(null, val);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            public void saveTo(T t, DataHolder section, String path) {
                this.saveTo(t, section, path, true);
            }

            @Override
            public void saveTo(T t, DataHolder section, String path, boolean overwrite) {
                try {
                    for (Field field : fields) {
                        Object obj = field.get(null);
                        StaticRootConverter.saveWith((TypeConverter)converters.get(field), obj, section, field.getName(), overwrite);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private static <T> void saveWith(TypeConverter<T> converter, Object obj, DataHolder section, String path, boolean overwrite) {
        converter.saveTo(obj, section, path, overwrite);
    }
}

