/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.conversion;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import redempt.redlib.config.ConfigManager;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.annotations.ConfigPath;
import redempt.redlib.config.annotations.ConfigPostInit;
import redempt.redlib.config.conversion.StringConverter;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;
import redempt.redlib.config.instantiation.InstantiationInfo;
import redempt.redlib.config.instantiation.Instantiator;

public class ObjectConverter {
    public static <T> TypeConverter<T> create(final ConfigManager manager, final ConfigType<?> type) {
        if (type.getType().isInterface() || Modifier.isAbstract(type.getType().getModifiers())) {
            throw new IllegalStateException("Cannot automatically convert abstract classe or interface " + type.getType());
        }
        final ArrayList<Field> fields = new ArrayList<Field>();
        final HashMap converters = new HashMap();
        final Instantiator instantiator = Instantiator.getInstantiator(type.getType());
        Field configPath = null;
        StringConverter<?> configPathConverter = null;
        for (Field field : type.getType().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
            field.setAccessible(true);
            if (field.isAnnotationPresent(ConfigPath.class)) {
                configPath = field;
                configPathConverter = manager.getStringConverter(ConfigType.get(configPath));
                continue;
            }
            fields.add(field);
            ConfigType<?> fieldType = ConfigType.get(field);
            converters.put(field, manager.getConverter(fieldType));
        }
        Method postInit = null;
        for (Method method : type.getType().getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (Modifier.isStatic(mod) || !method.isAnnotationPresent(ConfigPostInit.class)) continue;
            if (method.getParameterCount() != 0) {
                throw new IllegalStateException("Post-init method must have no parameters: " + method);
            }
            method.setAccessible(true);
            postInit = method;
            break;
        }
        final InstantiationInfo info = new InstantiationInfo(postInit, configPath, configPathConverter);
        return new TypeConverter<T>(){

            @Override
            public T loadFrom(DataHolder section, String path, T currentValue) {
                DataHolder newSection = path == null ? section : section.getSubsection(path);
                ArrayList<Object> objs = new ArrayList<Object>();
                for (Field field : fields) {
                    Object value = ((TypeConverter)converters.get(field)).loadFrom(newSection, field.getName(), null);
                    objs.add(value);
                }
                return instantiator.instantiate(manager, currentValue, type.getType(), fields, objs, path, info);
            }

            @Override
            public void saveTo(T t, DataHolder section, String path) {
                this.saveTo(t, section, path, true);
            }

            @Override
            public void saveTo(T t, DataHolder section, String path, boolean overwrite) {
                if (path != null && section.isSet(path) && !overwrite) {
                    return;
                }
                DataHolder newSection = path == null ? section : section.createSubsection(path);
                try {
                    for (Field field : fields) {
                        ObjectConverter.saveWith((TypeConverter)converters.get(field), field.get(t), newSection, field.getName(), overwrite);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private static <T> void saveWith(TypeConverter<T> converter, Object obj, DataHolder section, String path, boolean overwrite) {
        converter.saveTo(obj, section, path, overwrite);
    }
}

