/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.annotations.ConfigMappable;
import redempt.redlib.config.conversion.CollectionConverter;
import redempt.redlib.config.conversion.EnumConverter;
import redempt.redlib.config.conversion.MapConverter;
import redempt.redlib.config.conversion.NativeConverter;
import redempt.redlib.config.conversion.ObjectConverter;
import redempt.redlib.config.conversion.StaticRootConverter;
import redempt.redlib.config.conversion.StringConverter;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.ConfigurationSectionDataHolder;
import redempt.redlib.config.data.DataHolder;

public class ConfigManager {
    private Map<ConfigType<?>, TypeConverter<?>> convertersByType = new HashMap();
    private FileConfiguration config;
    private DataHolder holder;
    private File file;
    private TypeConverter<?> converter;
    private Object target;
    private Class<?> targetClass;

    public static ConfigManager create(File file) {
        return new ConfigManager(file);
    }

    public static ConfigManager create(Path path) {
        return ConfigManager.create(path.toFile());
    }

    public static ConfigManager create(Plugin plugin, String configName) {
        return ConfigManager.create(plugin.getDataFolder().toPath().resolve(configName));
    }

    public static ConfigManager create(Plugin plugin) {
        return ConfigManager.create(plugin, "config.yml");
    }

    private ConfigManager(File file) {
        this.convertersByType.put(new ConfigType<String>(String.class), StringConverter.create((String s) -> s, (T s) -> s));
        this.convertersByType.put(new ConfigType<Integer>(Integer.TYPE), StringConverter.create(Integer::parseInt, String::valueOf));
        this.convertersByType.put(new ConfigType<Double>(Double.TYPE), StringConverter.create(Double::parseDouble, String::valueOf));
        this.convertersByType.put(new ConfigType<Float>(Float.TYPE), StringConverter.create(Float::parseFloat, String::valueOf));
        this.convertersByType.put(new ConfigType<Boolean>(Boolean.TYPE), StringConverter.create(Boolean::parseBoolean, String::valueOf));
        this.convertersByType.put(new ConfigType<Long>(Long.TYPE), StringConverter.create(Long::parseLong, String::valueOf));
        this.file = file;
        file.getParentFile().mkdirs();
        if (file.exists()) {
            this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        } else {
            this.setConfig((FileConfiguration)new YamlConfiguration());
        }
    }

    private void setConfig(FileConfiguration config) {
        this.config = config;
        this.holder = new ConfigurationSectionDataHolder((ConfigurationSection)config);
    }

    public ConfigManager target(Object obj) {
        if (this.target != null || this.targetClass != null) {
            throw new IllegalStateException("ConfigManager already has a target");
        }
        this.target = obj;
        this.converter = ObjectConverter.create(this, new ConfigType(obj.getClass()));
        return this;
    }

    public ConfigManager target(Class<?> clazz) {
        if (this.target != null || this.targetClass != null) {
            throw new IllegalStateException("ConfigManager already has a target");
        }
        this.targetClass = clazz;
        this.converter = StaticRootConverter.create(this, clazz);
        return this;
    }

    public ConfigManager save() {
        this.save(this.converter, true);
        return this;
    }

    public ConfigManager saveDefaults() {
        this.save(this.converter, false);
        return this;
    }

    public ConfigManager load() {
        this.load(this.converter);
        return this;
    }

    private <T> void load(TypeConverter<T> converter) {
        converter.loadFrom(this.holder, null, this.target);
    }

    public ConfigManager reload() {
        this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)this.file));
        return this.load();
    }

    private <T> void save(TypeConverter<T> converter, boolean overwrite) {
        converter.saveTo(this.target, this.holder, null, overwrite);
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public <T> TypeConverter<T> getConverter(ConfigType<T> type) {
        if (type == null) {
            return null;
        }
        TypeConverter<Object> converter = this.convertersByType.get(type);
        if (converter == null) {
            converter = this.createConverter(type);
            this.convertersByType.put(type, converter);
        }
        return converter;
    }

    public <T> ConfigManager addConverter(Class<T> clazz, Function<String, T> loader, Function<T, String> saver) {
        this.convertersByType.put(new ConfigType<T>(clazz), StringConverter.create(loader, saver));
        return this;
    }

    public <T> ConfigManager addConverter(ConfigType<T> type, TypeConverter<T> converter) {
        this.convertersByType.put(type, converter);
        return this;
    }

    public <T> StringConverter<T> getStringConverter(ConfigType<T> type) {
        TypeConverter<?> keyConverter = this.convertersByType.get(type);
        if (!(keyConverter instanceof StringConverter)) {
            throw new IllegalStateException("No appropriate string converter for key type " + type);
        }
        return (StringConverter)keyConverter;
    }

    private <T> TypeConverter<?> createConverter(ConfigType<?> type) {
        if (Enum.class.isAssignableFrom(type.getType())) {
            return EnumConverter.create(type.getType());
        }
        if (Collection.class.isAssignableFrom(type.getType())) {
            return CollectionConverter.create(this, type);
        }
        if (Map.class.isAssignableFrom(type.getType())) {
            return MapConverter.create(this, type);
        }
        if (type.getType().isAnnotationPresent(ConfigMappable.class) || type.getType().getSuperclass().getName().equals("java.lang.Record")) {
            return ObjectConverter.create(this, type);
        }
        return NativeConverter.create();
    }
}

