/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.multiblock;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;
import redempt.redlib.RedLib;
import redempt.redlib.multiblock.Rotator;

public class StructureData {
    private BlockData data;
    private MaterialData mdata;

    protected StructureData(String string) {
        if (RedLib.MID_VERSION >= 13) {
            this.data = Bukkit.createBlockData((String)string);
        } else {
            String[] split = string.split(":");
            Material type = Material.valueOf((String)split[0]);
            byte data = 0;
            if (split.length == 2) {
                data = Byte.parseByte(split[1]);
            }
            this.mdata = new MaterialData(type, data);
        }
    }

    public StructureData(Material type) {
        if (RedLib.MID_VERSION >= 13) {
            this.data = type.createBlockData();
        } else {
            this.mdata = new MaterialData(type, 0);
        }
    }

    public StructureData(BlockData data) {
        this.data = data;
    }

    public StructureData getRotated(Rotator rotator) {
        if (RedLib.MID_VERSION >= 13) {
            return new StructureData(rotator.rotate(this.data));
        }
        return this;
    }

    public StructureData(Material type, byte data) {
        this.mdata = new MaterialData(type, data);
    }

    public void setBlock(Block block) {
        if (RedLib.MID_VERSION >= 13) {
            block.setBlockData(this.data, false);
        } else {
            BlockState state = block.getState();
            state.setType(this.mdata.getItemType());
            state.setRawData(this.mdata.getData());
            state.update(true, false);
        }
    }

    public BlockState getState(Block block) {
        if (RedLib.MID_VERSION >= 13) {
            BlockState state = block.getState();
            state.setBlockData(this.data);
            return state;
        }
        BlockState state = block.getState();
        state.setType(this.mdata.getItemType());
        state.setRawData(this.mdata.getData());
        return state;
    }

    public void sendBlock(Player player, Location loc) {
        if (RedLib.MID_VERSION >= 13) {
            player.sendBlockChange(loc, this.data);
        } else {
            player.sendBlockChange(loc, this.mdata.getItemType(), this.mdata.getData());
        }
    }

    public boolean isAir() {
        return RedLib.MID_VERSION >= 15 ? this.getType().isAir() : this.getType() == Material.AIR;
    }

    public Material getType() {
        return RedLib.MID_VERSION >= 13 ? this.data.getMaterial() : this.mdata.getItemType();
    }

    public boolean compare(Block block, boolean strict, boolean ignoreAir) {
        if (ignoreAir && this.isAir()) {
            return true;
        }
        if (!strict) {
            return block.getType() == this.getType();
        }
        if (RedLib.MID_VERSION >= 13) {
            return block.getBlockData().matches(this.data);
        }
        return block.getData() == this.mdata.getData() && block.getType() == this.mdata.getItemType();
    }
}

