/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import redempt.redlib.RedLib;

public class Task {
    private int task;
    private TaskType type;
    private Plugin plugin;

    public static Task syncDelayed(Runnable run) {
        return Task.syncDelayed(RedLib.getCallingPlugin(), run);
    }

    public static Task syncDelayed(Plugin plugin, Runnable run) {
        return Task.syncDelayed(plugin, run, 0L);
    }

    public static Task syncDelayed(Consumer<Task> run) {
        return Task.syncDelayed(RedLib.getCallingPlugin(), run);
    }

    public static Task syncDelayed(Plugin plugin, Consumer<Task> run) {
        return Task.syncDelayed(plugin, run, 0L);
    }

    public static Task syncDelayed(Runnable run, long delay) {
        return Task.syncDelayed(RedLib.getCallingPlugin(), run, delay);
    }

    public static Task syncDelayed(Plugin plugin, Runnable run, long delay) {
        return Task.syncDelayed(plugin, (Task t) -> run.run(), delay);
    }

    public static Task syncDelayed(Consumer<Task> run, long delay) {
        return Task.syncDelayed(RedLib.getCallingPlugin(), run, delay);
    }

    public static Task syncDelayed(Plugin plugin, Consumer<Task> run, long delay) {
        Task[] task = new Task[]{null};
        task[0] = new Task(Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, () -> run.accept(task[0]), delay), TaskType.SYNC_DELAYED, plugin);
        return task[0];
    }

    public static Task syncRepeating(Runnable run, long delay, long period) {
        return Task.syncRepeating(RedLib.getCallingPlugin(), run, delay, period);
    }

    public static Task syncRepeating(Plugin plugin, Runnable run, long delay, long period) {
        return Task.syncRepeating(plugin, (Task t) -> run.run(), delay, period);
    }

    public static Task syncRepeating(Consumer<Task> run, long delay, long period) {
        return Task.syncRepeating(RedLib.getCallingPlugin(), run, delay, period);
    }

    public static Task syncRepeating(Plugin plugin, Consumer<Task> run, long delay, long period) {
        Task[] task = new Task[]{null};
        task[0] = new Task(Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, () -> run.accept(task[0]), delay, period), TaskType.SYNC_REPEATING, plugin);
        return task[0];
    }

    public static Task asyncDelayed(Runnable run) {
        return Task.asyncDelayed(RedLib.getCallingPlugin(), run);
    }

    public static Task asyncDelayed(Plugin plugin, Runnable run) {
        return Task.asyncDelayed(plugin, (Task t) -> run.run(), 0L);
    }

    public static Task asyncDelayed(Consumer<Task> run) {
        return Task.asyncDelayed(RedLib.getCallingPlugin(), run);
    }

    public static Task asyncDelayed(Plugin plugin, Consumer<Task> run) {
        return Task.asyncDelayed(plugin, run, 0L);
    }

    public static Task asyncDelayed(Runnable run, long delay) {
        return Task.asyncDelayed(RedLib.getCallingPlugin(), run, delay);
    }

    public static Task asyncDelayed(Plugin plugin, Runnable run, long delay) {
        return Task.asyncDelayed(plugin, (Task t) -> run.run(), delay);
    }

    public static Task asyncDelayed(Consumer<Task> run, long delay) {
        return Task.asyncDelayed(RedLib.getCallingPlugin(), run, delay);
    }

    public static Task asyncDelayed(Plugin plugin, Consumer<Task> run, long delay) {
        Task[] task = new Task[]{null};
        task[0] = new Task(Bukkit.getScheduler().scheduleAsyncDelayedTask(plugin, () -> run.accept(task[0]), delay), TaskType.ASYNC_DELAYED, plugin);
        return task[0];
    }

    public static Task asyncRepeating(Consumer<Task> run, long delay, long period) {
        return Task.asyncRepeating(RedLib.getCallingPlugin(), run, delay, period);
    }

    public static Task asyncRepeating(Plugin plugin, Consumer<Task> run, long delay, long period) {
        Task[] task = new Task[]{null};
        task[0] = new Task(Bukkit.getScheduler().scheduleAsyncRepeatingTask(plugin, () -> run.accept(task[0]), delay, period), TaskType.ASYNC_REPEATING, plugin);
        return task[0];
    }

    public static Task asyncRepeating(Runnable run, long delay, long period) {
        return Task.asyncRepeating(RedLib.getCallingPlugin(), run, delay, period);
    }

    public static Task asyncRepeating(Plugin plugin, Runnable run, long delay, long period) {
        return Task.asyncRepeating(plugin, (Task t) -> run.run(), delay, period);
    }

    private Task(int task, TaskType type, Plugin plugin) {
        this.task = task;
        this.type = type;
        this.plugin = plugin;
    }

    public TaskType getType() {
        return this.type;
    }

    public boolean isQueued() {
        return Bukkit.getScheduler().isQueued(this.task);
    }

    public boolean isCurrentlyRunning() {
        return Bukkit.getScheduler().isCurrentlyRunning(this.task);
    }

    public void cancel() {
        Bukkit.getScheduler().cancelTask(this.task);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public static enum TaskType {
        SYNC_DELAYED,
        ASYNC_DELAYED,
        SYNC_REPEATING,
        ASYNC_REPEATING;

    }
}

