/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.json;

import java.util.HashMap;
import java.util.Map;
import redempt.redlib.json.JSONList;
import redempt.redlib.json.JSONStorage;

public class JSONMap
extends HashMap<String, Object>
implements JSONStorage {
    private JSONStorage parent;
    protected String key;

    public int getInt(String key) {
        Object o = this.get(key);
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        return (Integer)o;
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public JSONList getList(String key) {
        return (JSONList)this.get(key);
    }

    public JSONMap getMap(String key) {
        return (JSONMap)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        for (Map.Entry entry : this.entrySet()) {
            builder.append('\"').append((String)entry.getKey()).append('\"').append(':');
            Object o = entry.getValue();
            if (o instanceof CharSequence) {
                builder.append('\"').append(o.toString().replace("\\", "\\\\").replace("\"", "\\\"")).append("\", ");
                continue;
            }
            if (o instanceof Long) {
                builder.append(o.toString()).append("L, ");
                continue;
            }
            builder.append(o).append(", ");
        }
        return builder.replace(builder.length() - 2, builder.length(), "}").toString();
    }

    @Override
    public JSONStorage getParent() {
        return this.parent;
    }

    @Override
    public void setParent(JSONStorage obj) {
        this.parent = obj;
    }

    @Override
    public void add(String key, Object value) {
        this.put(key, value);
    }

    @Override
    public String getTempKey() {
        return this.key;
    }

    @Override
    public void setTempKey(String value) {
        this.key = value;
    }
}

