/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.itemutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import redempt.redlib.RedLib;

public abstract class CustomItem {
    private String name;
    private ItemStack item;

    public static Map<String, CustomItem> getAll(Plugin plugin) {
        List<Class<CustomItem>> list = RedLib.getExtendingClasses(plugin, CustomItem.class);
        HashMap<String, CustomItem> map = new HashMap<String, CustomItem>();
        for (Class<CustomItem> clazz : list) {
            try {
                Constructor<CustomItem> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                CustomItem citem = constructor.newInstance(new Object[0]);
                map.put(citem.getName(), citem);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Class " + clazz.getName() + " does not have a default constructor or could not be loaded", e);
            }
        }
        return map;
    }

    protected CustomItem(String name) {
        this.name = name;
        this.item = this.getDefaultItem();
    }

    protected boolean cloneOnGet() {
        return false;
    }

    public abstract ItemStack getDefaultItem();

    public final String getName() {
        return this.name;
    }

    public ItemStack getItem() {
        if (this.cloneOnGet()) {
            return this.item.clone();
        }
        return this.item;
    }
}

