/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.enchants.events;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import redempt.redlib.RedLib;
import redempt.redlib.misc.Task;

public class PlayerChangedHeldItemEvent
extends PlayerEvent {
    private static HandlerList handlers = new HandlerList();
    private ItemStack oldItem;
    private ItemStack newItem;

    public static HandlerList getHandlerList() {
        return handlers;
    }

    private static void register() {
        Task.syncRepeating(RedLib.getInstance(), () -> Bukkit.getOnlinePlayers().forEach(PlayerChangedHeldItemEvent::check), 1L, 1L);
    }

    private static void check(Player player) {
        ItemStack held = player.getItemInHand();
        Task.syncDelayed(RedLib.getInstance(), () -> {
            ItemStack now = player.getItemInHand();
            if (held == null && now != null || !held.equals((Object)now)) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerChangedHeldItemEvent(player, held, now));
            }
        }, 1L);
    }

    public PlayerChangedHeldItemEvent(Player player, ItemStack oldItem, ItemStack newItem) {
        super(player);
        this.oldItem = oldItem;
        this.newItem = newItem;
    }

    public ItemStack getPreviousItem() {
        return this.oldItem;
    }

    public ItemStack getNewItem() {
        return this.newItem;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    static {
        PlayerChangedHeldItemEvent.register();
    }
}

