/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.dev.profiler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import redempt.redlib.dev.profiler.Profiler;
import redempt.redlib.dev.profiler.SampleSummary;

public class PassiveProfiler
extends Profiler {
    private Thread server;
    private ScheduledExecutorService scheduler;
    private SampleSummary summary = new SampleSummary();

    @Override
    public void start() {
        this.summary = new SampleSummary();
        if (this.server != null) {
            return;
        }
        this.server = Thread.currentThread();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(() -> new Thread(() -> {
            if (this.server == null) {
                return;
            }
            this.summary.add(this.server.getStackTrace());
        }).start(), 1L, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void end() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        this.server = null;
    }

    @Override
    public SampleSummary getSummary() {
        return this.summary.clone();
    }

    public SampleSummary getRunningSummary() {
        return this.summary;
    }
}

