/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.dev.profiler;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import redempt.redlib.dev.profiler.Profiler;
import redempt.redlib.dev.profiler.Sample;
import redempt.redlib.dev.profiler.SampleSummary;

public class BurstProfiler
extends Profiler {
    private Thread server;
    private ArrayBlockingQueue<Sample> samples;
    private ScheduledExecutorService scheduler;
    private int size;

    public BurstProfiler(int size) {
        this.size = size;
        this.samples = new ArrayBlockingQueue(size);
    }

    public BurstProfiler() {
        this(10000);
    }

    @Override
    public void start() {
        this.samples.clear();
        if (this.server != null) {
            return;
        }
        this.server = Thread.currentThread();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(() -> new Thread(() -> {
            if (this.server == null) {
                return;
            }
            Sample sample = new Sample(this.server.getStackTrace(), System.currentTimeMillis());
            while (!this.samples.offer(sample)) {
                this.samples.poll();
            }
        }).start(), 1L, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void end() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        this.server = null;
    }

    @Override
    public SampleSummary getSummary() {
        return new SampleSummary(this.samples);
    }

    public SampleSummary getSummary(long after) {
        long start = ((Sample)this.samples.element()).getTime();
        long diff = after - start;
        ArrayList<Sample> list = new ArrayList<Sample>();
        this.samples.stream().skip(Math.max(diff, 0L)).forEach(list::add);
        return new SampleSummary(list);
    }
}

