/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.configmanager;

import java.util.LinkedHashSet;
import org.bukkit.configuration.ConfigurationSection;
import redempt.redlib.configmanager.ConfigManager;
import redempt.redlib.configmanager.ConfigObjectMapper;
import redempt.redlib.configmanager.ConfigStorage;
import redempt.redlib.configmanager.ConversionType;

class ConfigSet<T>
extends LinkedHashSet<T>
implements ConfigStorage {
    protected Class<T> clazz;
    private ConfigObjectMapper<T> mapper;
    private ConfigManager manager;
    private ConversionType type;

    public ConfigSet(Class<T> clazz, ConversionType type) {
        this.clazz = clazz;
        this.type = type;
    }

    @Override
    public void init(ConfigManager manager) {
        if (this.manager != null) {
            return;
        }
        this.mapper = new ConfigObjectMapper<T>(this.clazz, this.type, manager);
        this.manager = manager;
    }

    @Override
    public void save(ConfigurationSection section) {
        int[] count = new int[]{0};
        this.forEach(i -> {
            this.mapper.save(section, count[0] + "", i);
            count[0] = count[0] + 1;
        });
    }

    @Override
    public void load(ConfigurationSection section) {
        this.clear();
        section.getKeys(false).forEach(k -> this.add(this.mapper.load(section, (String)k)));
    }
}

