/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.configmanager;

import java.util.LinkedHashMap;
import org.bukkit.configuration.ConfigurationSection;
import redempt.redlib.configmanager.ConfigManager;
import redempt.redlib.configmanager.ConfigObjectMapper;
import redempt.redlib.configmanager.ConfigStorage;
import redempt.redlib.configmanager.ConversionType;
import redempt.redlib.configmanager.TypeConverter;
import redempt.redlib.configmanager.exceptions.ConfigMapException;

class ConfigMap<K, V>
extends LinkedHashMap<K, V>
implements ConfigStorage {
    protected Class<V> valueClass;
    private Class<K> keyClass;
    protected ConfigurationSection section;
    private ConfigManager manager;
    private ConfigObjectMapper<V> mapper;
    private TypeConverter<K> converter;
    private ConversionType type;

    public ConfigMap(Class<K> keyClass, Class<V> valueClass, ConversionType type) {
        this.valueClass = valueClass;
        this.keyClass = keyClass;
        this.type = type;
    }

    @Override
    public void init(ConfigManager manager) {
        if (this.manager != null) {
            return;
        }
        this.mapper = new ConfigObjectMapper<V>(this.valueClass, this.type, manager);
        this.manager = manager;
    }

    @Override
    public void load(ConfigurationSection section) {
        this.clear();
        this.section = section;
        section.getKeys(false).forEach((? super T k) -> super.put(this.getObjKey((String)k), this.mapper.load(section, (String)k)));
    }

    @Override
    public void save(ConfigurationSection section) {
        this.section = section;
        this.forEach((k, v) -> this.mapper.save(section, this.getStringKey(k), v));
    }

    @Override
    public V put(K key, V value) {
        V out = super.put(key, value);
        if (this.section != null) {
            String skey = this.getStringKey(key);
            ConfigurationSection section = this.section.getConfigurationSection(skey);
            section = section == null ? this.section.createSection(skey) : section;
            this.mapper.setPathField(value, section);
        }
        return out;
    }

    private String getStringKey(K key) {
        if (this.keyClass.equals(String.class)) {
            return (String)key;
        }
        if (this.converter == null) {
            this.converter = this.manager.getConverter(this.keyClass);
            if (this.converter == null) {
                throw new ConfigMapException("No converter for class " + this.keyClass.getName());
            }
        }
        return this.converter.save(key);
    }

    private K getObjKey(String key) {
        if (this.keyClass.equals(String.class)) {
            return (K)key;
        }
        if (this.converter == null) {
            this.converter = this.manager.getConverter(this.keyClass);
            if (this.converter == null) {
                throw new ConfigMapException("No converter for class " + this.keyClass.getName());
            }
        }
        return this.converter.load(key);
    }
}

