/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.configmanager;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import redempt.redlib.configmanager.ConfigCollection;
import redempt.redlib.configmanager.ConfigField;
import redempt.redlib.configmanager.ConfigList;
import redempt.redlib.configmanager.ConfigMap;
import redempt.redlib.configmanager.ConfigSet;
import redempt.redlib.configmanager.ConversionType;
import redempt.redlib.configmanager.TypeConverter;
import redempt.redlib.configmanager.annotations.ConfigValue;

public class ConfigManager {
    private YamlConfiguration config;
    private File file = null;
    private Map<Object, List<ConfigField>> data = new HashMap<Object, List<ConfigField>>();
    private boolean registered = false;
    private Map<Class<?>, TypeConverter<?>> converters = new HashMap();

    public static List<String> stringList(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, strings);
        return list;
    }

    public static <T> ConfigMap<String, T> map(Class<T> clazz) {
        return ConfigManager.map(clazz, ConversionType.AUTO);
    }

    public static <T> ConfigMap<String, T> map(Class<T> clazz, ConversionType type) {
        return new ConfigMap<String, T>(String.class, clazz, type);
    }

    public static <K, V> ConfigMap<K, V> map(Class<K> keyClass, Class<V> valueClass) {
        return ConfigManager.map(keyClass, valueClass, ConversionType.AUTO);
    }

    public static <K, V> ConfigMap<K, V> map(Class<K> keyClass, Class<V> valueClass, ConversionType type) {
        return new ConfigMap<K, V>(keyClass, valueClass, type);
    }

    public static <T> ConfigList<T> list(Class<T> clazz, T ... elements) {
        return ConfigManager.list(clazz, ConversionType.AUTO, elements);
    }

    public static <T> ConfigList<T> list(Class<T> clazz, ConversionType type, T ... elements) {
        ConfigList<T> list = new ConfigList<T>(clazz, type);
        Collections.addAll(list, elements);
        return list;
    }

    public static <T> ConfigSet<T> set(Class<T> clazz, T ... elements) {
        return ConfigManager.set(clazz, ConversionType.AUTO, elements);
    }

    public static <T> ConfigSet<T> set(Class<T> clazz, ConversionType type, T ... elements) {
        ConfigSet<T> set = new ConfigSet<T>(clazz, type);
        Collections.addAll(set, elements);
        return set;
    }

    public static <T> ConfigCollection<T> collection(Class<T> clazz, ConversionType type, Collection<T> toWrap, T ... elements) {
        Collections.addAll(toWrap, elements);
        return new ConfigCollection<T>(clazz, type, toWrap);
    }

    public static <T> ConfigCollection<T> collection(Class<T> clazz, Collection<T> toWrap, T ... elements) {
        Collections.addAll(toWrap, elements);
        return new ConfigCollection<T>(clazz, ConversionType.AUTO, toWrap);
    }

    public ConfigManager(Plugin plugin) {
        this(plugin, "config.yml");
    }

    public ConfigManager(Plugin plugin, String name) {
        this(new File(plugin.getDataFolder(), name));
    }

    public ConfigManager(File file) {
        this.file = file;
        file.getParentFile().mkdirs();
        this.config = file.exists() ? YamlConfiguration.loadConfiguration((File)file) : new YamlConfiguration();
        this.converters.put(Integer.class, new TypeConverter<Integer>(Integer::parseInt, Object::toString));
        this.converters.put(Long.class, new TypeConverter<Long>(Long::parseLong, Object::toString));
        this.converters.put(Double.class, new TypeConverter<Double>(Double::parseDouble, Object::toString));
        this.converters.put(Boolean.class, new TypeConverter<Boolean>(Boolean::valueOf, Object::toString));
        this.converters.put(Float.class, new TypeConverter<Float>(Float::parseFloat, Object::toString));
        this.converters.put(Float.TYPE, new TypeConverter<Float>(Float::parseFloat, Object::toString));
    }

    public <T> ConfigManager addConverter(Class<T> clazz, Function<String, T> load, Function<T, String> save) {
        this.converters.put(clazz, new TypeConverter<T>(load, save));
        return this;
    }

    protected <T> TypeConverter<T> getConverter(Class<T> clazz) {
        TypeConverter<Object> converter = this.converters.get(clazz);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            converter = this.enumConverter(clazz);
            this.converters.put(clazz, converter);
        }
        return converter;
    }

    private <T extends Enum<T>> TypeConverter<T> enumConverter(Class<?> clazz) {
        Class<?> enumClazz = clazz;
        return new TypeConverter<Enum>(s -> Enum.valueOf(enumClazz, s), Enum::name);
    }

    public ConfigManager(Path path) {
        this(path.toFile());
    }

    public ConfigManager register(Object ... data) {
        for (Object obj : data) {
            ArrayList<ConfigField> fields = new ArrayList<ConfigField>();
            for (Field field : obj instanceof Class ? ((Class)obj).getDeclaredFields() : obj.getClass().getDeclaredFields()) {
                ConfigValue hook = field.getAnnotation(ConfigValue.class);
                if (hook == null) continue;
                String value = hook.value();
                value = value.length() == 0 ? field.getName() : value;
                fields.add(new ConfigField(hook.type(), field, value, hook.priority(), this));
            }
            this.data.put(obj, fields);
            fields.sort(Comparator.comparingInt(f -> f.priority));
        }
        this.registered = true;
        return this;
    }

    public boolean configExists() {
        return this.file.exists();
    }

    public ConfigManager saveDefaults() {
        if (!this.registered) {
            throw new IllegalStateException("Config manager is not registered");
        }
        this.data.forEach((k, v) -> v.forEach(f -> f.saveIfAbsent(k, (ConfigurationSection)this.config)));
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public ConfigManager load() {
        if (!this.registered) {
            throw new IllegalStateException("Config manager is not registered");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.data.forEach((k, v) -> v.forEach(f -> f.load(k, (ConfigurationSection)this.config)));
        return this;
    }

    public ConfigManager save() {
        if (!this.registered) {
            throw new IllegalStateException("Config manager is not registered");
        }
        this.data.forEach((k, v) -> v.forEach(f -> f.save(k, (ConfigurationSection)this.config)));
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }
}

