/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.worldgen;

import java.util.Random;

public class NoiseGenerator {
    private static SVec[] vecs = new SVec[]{new SVec(1.0, 0.0, 1.0), new SVec(1.0, 0.0, -1.0), new SVec(-1.0, 0.0, 1.0), new SVec(-1.0, 0.0, -1.0), new SVec(1.0, 0.0, 0.0), new SVec(0.0, 0.0, 1.0), new SVec(-1.0, 0.0, 0.0), new SVec(0.0, 0.0, -1.0)};
    private static SVec[] vecs3 = new SVec[]{new SVec(1.0, 1.0, 0.0), new SVec(-1.0, 1.0, 0.0), new SVec(1.0, -1.0, 0.0), new SVec(-1.0, -1.0, 0.0), new SVec(1.0, 0.0, 1.0), new SVec(1.0, 0.0, -1.0), new SVec(-1.0, 0.0, 1.0), new SVec(-1.0, 0.0, -1.0), new SVec(0.0, 1.0, 1.0), new SVec(0.0, 1.0, -1.0), new SVec(0.0, -1.0, 1.0), new SVec(0.0, -1.0, -1.0)};
    private long seed;
    private double scale = 1.0;
    private double weight = 1.0;
    private Random random;
    private SVec[][][] prefill = null;
    private int[] prefillPos = new int[]{0, 0, 0};

    private static long hash(long ... nums) {
        long hash = 23L;
        for (long num : nums) {
            if (num == 0L) {
                hash += 143L;
                continue;
            }
            hash *= num;
            hash += 37L;
        }
        return hash;
    }

    private static SVec generateVector(long hash, Random random) {
        random.setSeed(hash);
        return vecs[random.nextInt(8)];
    }

    private static SVec generateVector3(long hash, Random random) {
        random.setSeed(hash);
        return vecs3[random.nextInt(12)];
    }

    public static double smoothstep(double first, double second, double w) {
        double value = w * w * w * (w * (w * 6.0 - 15.0) + 10.0);
        return first + value * (second - first);
    }

    public NoiseGenerator(long seed) {
        this.seed = seed;
        this.random = new Random();
    }

    public NoiseGenerator() {
        this(new Random().nextLong());
    }

    public void setScale(double scale) {
        if (scale < 0.0) {
            throw new IllegalArgumentException("Scale cannot be negative");
        }
        this.scale = scale;
    }

    public void setWeight(double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("Weight cannot be negative");
        }
        this.weight = weight;
    }

    public double getScale() {
        return this.scale;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void prefill(int x, int y, int z, int width, int height, int length) {
        x = (int)Math.floor((double)x * this.scale);
        y = (int)Math.floor((double)y * this.scale);
        z = (int)Math.floor((double)z * this.scale);
        width = (int)Math.ceil((double)width * this.scale) + 1;
        height = (int)Math.ceil((double)height * this.scale) + 1;
        length = (int)Math.ceil((double)length * this.scale) + 1;
        this.prefillPos[0] = x;
        this.prefillPos[1] = y;
        this.prefillPos[2] = z;
        this.prefill = new SVec[width][height][length];
        for (int xp = 0; xp < width; ++xp) {
            for (int yp = 0; yp < height; ++yp) {
                for (int zp = 0; zp < length; ++zp) {
                    this.prefill[xp][yp][zp] = NoiseGenerator.generateVector3(NoiseGenerator.hash(this.seed, x + xp, y + yp, z + zp), this.random);
                }
            }
        }
    }

    public void prefill(int x, int z, int width, int length) {
        x = (int)Math.floor((double)x * this.scale);
        z = (int)Math.floor((double)z * this.scale);
        width = (int)Math.ceil((double)width * this.scale) + 1;
        length = (int)Math.ceil((double)length * this.scale) + 1;
        this.prefillPos[0] = x;
        this.prefillPos[1] = 0;
        this.prefillPos[2] = z;
        this.prefill = new SVec[width][1][length];
        for (int xp = 0; xp < width; ++xp) {
            for (int zp = 0; zp < length; ++zp) {
                this.prefill[xp][0][zp] = NoiseGenerator.generateVector(NoiseGenerator.hash(this.seed, x + xp, z + zp), this.random);
            }
        }
    }

    private SVec getVector(int x, int y, int z) {
        if (this.prefill != null && x >= this.prefillPos[0] && x < this.prefillPos[0] + this.prefill.length && y >= this.prefillPos[1] && y < this.prefillPos[1] + this.prefill[0].length && z >= this.prefillPos[2] && z < this.prefillPos[2] + this.prefill[0][0].length) {
            return this.prefill[x - this.prefillPos[0]][y - this.prefillPos[1]][z - this.prefillPos[2]];
        }
        return NoiseGenerator.generateVector3(NoiseGenerator.hash(this.seed, x, y, z), this.random);
    }

    private SVec getVector(int x, int z) {
        if (this.prefill != null && x >= this.prefillPos[0] && x < this.prefillPos[0] + this.prefill.length && z >= this.prefillPos[2] && z < this.prefillPos[2] + this.prefill[0][0].length) {
            return this.prefill[x - this.prefillPos[0]][0][z - this.prefillPos[2]];
        }
        return NoiseGenerator.generateVector(NoiseGenerator.hash(this.seed, x, z), this.random);
    }

    public double noise(double x, double z) {
        int minX = (int)Math.floor(x *= this.scale);
        int minZ = (int)Math.floor(z *= this.scale);
        double[] dots = new double[]{this.getVector(minX, minZ).dot(x -= (double)minX, z -= (double)minZ), this.getVector(minX, minZ + 1).dot(x, z - 1.0), this.getVector(minX + 1, minZ).dot(x - 1.0, z), this.getVector(minX + 1, minZ + 1).dot(x - 1.0, z - 1.0)};
        dots[0] = NoiseGenerator.smoothstep(dots[0], dots[1], z);
        dots[1] = NoiseGenerator.smoothstep(dots[2], dots[3], z);
        dots[0] = NoiseGenerator.smoothstep(dots[0], dots[1], x);
        return dots[0] * this.weight;
    }

    public double noise(double x, double y, double z) {
        int minX = (int)Math.floor(x *= this.scale);
        int minY = (int)Math.floor(y *= this.scale);
        int minZ = (int)Math.floor(z *= this.scale);
        double[] dots = new double[]{this.getVector(minX, minY, minZ).dot(x -= (double)minX, y -= (double)minY, z -= (double)minZ), this.getVector(minX, minY, minZ + 1).dot(x, y, z - 1.0), this.getVector(minX, minY + 1, minZ).dot(x, y - 1.0, z), this.getVector(minX, minY + 1, minZ + 1).dot(x, y - 1.0, z - 1.0), this.getVector(minX + 1, minY, minZ).dot(x - 1.0, y, z), this.getVector(minX + 1, minY, minZ + 1).dot(x - 1.0, y, z - 1.0), this.getVector(minX + 1, minY + 1, minZ).dot(x - 1.0, y - 1.0, z), this.getVector(minX + 1, minY + 1, minZ + 1).dot(x - 1.0, y - 1.0, z - 1.0)};
        dots[0] = NoiseGenerator.smoothstep(dots[0], dots[1], z);
        dots[1] = NoiseGenerator.smoothstep(dots[2], dots[3], z);
        dots[2] = NoiseGenerator.smoothstep(dots[4], dots[5], z);
        dots[3] = NoiseGenerator.smoothstep(dots[6], dots[7], z);
        dots[0] = NoiseGenerator.smoothstep(dots[0], dots[1], y);
        dots[1] = NoiseGenerator.smoothstep(dots[2], dots[3], y);
        dots[0] = NoiseGenerator.smoothstep(dots[0], dots[1], x);
        return dots[0] * this.weight;
    }

    private static class SVec {
        private double x;
        private double y;
        private double z;

        public SVec(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double length() {
            return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
        }

        public SVec normalize() {
            double length = this.length();
            this.x /= length;
            this.y /= length;
            this.z /= length;
            return this;
        }

        public double dot(SVec v) {
            return this.x * v.x + this.y * v.y + this.z * v.z;
        }

        public double dot(double x, double z) {
            return x * this.x + z * this.z;
        }

        public double dot(double x, double y, double z) {
            return x * this.x + y * this.y + z * this.z;
        }

        public SVec clone() {
            return new SVec(this.x, this.y, this.z);
        }

        public String toString() {
            return this.x + ", " + this.y + ", " + this.z;
        }
    }
}

