/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.bukkit.block.BlockFace;
import redempt.redlib.region.Region;

class MultiRegionMeta {
    private List<TreeSet<Double>> points = new ArrayList<TreeSet<Double>>();

    public MultiRegionMeta(List<Region> regions) {
        for (int i = 0; i < 6; ++i) {
            TreeSet<Double> direction = new TreeSet<Double>();
            for (Region region : regions) {
                direction.add(this.getCoordinate(region, i));
            }
            this.points.add(direction);
        }
    }

    public double getNextStep(BlockFace face, double current) {
        int index = this.getBlockFaceIndex(face);
        TreeSet<Double> list = this.points.get(index);
        Double next = index >= 3 ? list.lower(current) : list.higher(current);
        return next == null ? current : next;
    }

    public double getCurrentStep(Region region, BlockFace face) {
        return this.getCoordinate(region, this.getBlockFaceIndex(face));
    }

    private int getBlockFaceIndex(BlockFace face) {
        switch (face) {
            case EAST: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
            case DOWN: {
                return 4;
            }
            case NORTH: {
                return 5;
            }
        }
        return -1;
    }

    private double getCoordinate(Region region, int coord) {
        switch (coord) {
            case 0: {
                return region.getEnd().getX();
            }
            case 1: {
                return region.getEnd().getY();
            }
            case 2: {
                return region.getEnd().getZ();
            }
            case 3: {
                return region.getStart().getX();
            }
            case 4: {
                return region.getStart().getY();
            }
            case 5: {
                return region.getStart().getZ();
            }
        }
        return 0.0;
    }
}

