/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.conversion;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;
import redempt.redlib.config.ConfigManager;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;
import redempt.redlib.config.data.ListDataHolder;

public class CollectionConverter {
    private static Map<Class<?>, Supplier<? extends Collection<?>>> defaults = new HashMap();

    public static <V, T extends Collection<V>> TypeConverter<T> create(ConfigManager manager, final ConfigType<?> collectionType) {
        ConfigType<?> componentType = collectionType.getComponentTypes().get(0);
        final TypeConverter<?> converter = manager.getConverter(componentType);
        return new TypeConverter<T>(){

            @Override
            public T loadFrom(DataHolder section, String path, T currentValue) {
                DataHolder newSection;
                if (currentValue == null) {
                    currentValue = (Collection)((Supplier)defaults.get(collectionType.getType())).get();
                } else {
                    currentValue.clear();
                }
                DataHolder dataHolder = newSection = path == null ? section : section.getList(path);
                if (newSection == null) {
                    return null;
                }
                Object collection = currentValue;
                newSection.getKeys().forEach(k -> {
                    Object obj = converter.loadFrom(newSection, (String)k, null);
                    collection.add(obj);
                });
                return collection;
            }

            @Override
            public void saveTo(T t, DataHolder section, String path) {
                ListDataHolder newSection = new ListDataHolder();
                int pos = 0;
                for (Object obj : t) {
                    converter.saveTo(obj, newSection, String.valueOf(pos));
                    ++pos;
                }
                section.set(path, newSection);
            }
        };
    }

    static {
        defaults.put(List.class, ArrayList::new);
        defaults.put(Set.class, LinkedHashSet::new);
        defaults.put(Queue.class, ArrayDeque::new);
    }
}

