/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;
import redempt.redlib.misc.LocationUtils;
import redempt.redlib.multiblock.Rotator;
import redempt.redlib.region.CuboidRegion;
import redempt.redlib.region.Region;

public class SpheroidRegion
extends Region {
    private double xRad;
    private double yRad;
    private double zRad;
    private Location center;
    private CuboidRegion cuboid;
    private Set<Block> surface;

    public SpheroidRegion(Location start, Location end) {
        if (!start.getWorld().equals((Object)end.getWorld())) {
            throw new IllegalArgumentException("Corners must be in the same world");
        }
        this.center = start.clone().add(end).multiply(0.5);
        this.xRad = Math.abs(start.getX() - end.getX()) / 2.0;
        this.yRad = Math.abs(start.getY() - end.getY()) / 2.0;
        this.zRad = Math.abs(start.getZ() - end.getZ()) / 2.0;
    }

    public SpheroidRegion(Location center, double xRad, double yRad, double zRad) {
        this.center = center;
        this.xRad = xRad;
        this.yRad = yRad;
        this.zRad = zRad;
    }

    public SpheroidRegion(Location center, double radius) {
        this(center, radius, radius, radius);
    }

    @Override
    public double getVolume() {
        return Math.PI * this.xRad * this.yRad * this.zRad;
    }

    @Override
    public int getBlockVolume() {
        return (int)this.getVolume();
    }

    @Override
    public SpheroidRegion expand(double posX, double negX, double posY, double negY, double posZ, double negZ) {
        this.xRad += posX + negX;
        this.yRad += posY + negY;
        this.zRad += posZ + negZ;
        this.move(posX - negX, posY - negY, posZ - negZ);
        this.clearCached();
        return this;
    }

    @Override
    public SpheroidRegion expand(BlockFace face, double amount) {
        this.clearCached();
        switch (face) {
            case UP: 
            case DOWN: {
                this.yRad += amount / 2.0;
                break;
            }
            case EAST: 
            case WEST: {
                this.xRad += amount / 2.0;
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.zRad += amount / 2.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Face must be UP, DOWN, NORTH, SOUTH, EAST, or WEST");
            }
        }
        this.move(LocationUtils.getDirection(face).multiply(amount / 2.0));
        this.clearCached();
        return this;
    }

    public SpheroidRegion expand(double amount) {
        this.xRad += amount;
        this.yRad += amount;
        this.zRad += amount;
        this.clearCached();
        return this;
    }

    @Override
    public SpheroidRegion move(Vector vec) {
        this.center.add(vec);
        this.clearCached();
        return this;
    }

    @Override
    public SpheroidRegion move(double x, double y, double z) {
        return this.move(new Vector(x, y, z));
    }

    private double distanceSquared(Location loc) {
        return Math.pow((loc.getX() - this.center.getX()) / this.xRad, 2.0) + Math.pow((loc.getY() - this.center.getY()) / this.yRad, 2.0) + Math.pow((loc.getZ() - this.center.getZ()) / this.zRad, 2.0);
    }

    private void clearCached() {
        this.surface = null;
        this.cuboid = null;
    }

    @Override
    public boolean contains(Location loc) {
        return this.center.getWorld().equals((Object)loc.getWorld()) && this.distanceSquared(loc) <= 1.0;
    }

    public boolean isSphere() {
        return this.xRad == this.yRad && this.yRad == this.zRad;
    }

    @Override
    public SpheroidRegion clone() {
        return new SpheroidRegion(this.center.clone(), this.xRad, this.yRad, this.zRad);
    }

    @Override
    public SpheroidRegion rotate(Location center, int rotations) {
        Rotator rotator = new Rotator(rotations, false);
        rotator.setLocation(center.getX(), center.getZ());
        center.setX(rotator.getRotatedX());
        center.setZ(rotator.getRotatedZ());
        if (rotations % 2 == 1) {
            double tmp = this.xRad;
            this.xRad = this.zRad;
            this.zRad = tmp;
        }
        this.clearCached();
        return this;
    }

    @Override
    public SpheroidRegion setWorld(World world) {
        this.center.setWorld(world);
        this.clearCached();
        return this;
    }

    @Override
    public Stream<Block> stream() {
        return this.toCuboid().stream().filter(b -> this.contains(b.getLocation().add(0.5, 0.5, 0.5)));
    }

    @Override
    public CuboidRegion toCuboid() {
        if (this.cuboid == null) {
            this.cuboid = super.toCuboid();
        }
        return this.cuboid;
    }

    public double getXRadius() {
        return this.xRad;
    }

    public double getYRadius() {
        return this.yRad;
    }

    public double getZRadius() {
        return this.zRad;
    }

    public SpheroidRegion setXRadius(double xRad) {
        this.xRad = xRad;
        return this;
    }

    public SpheroidRegion setYRadius(double yRad) {
        this.yRad = yRad;
        return this;
    }

    public SpheroidRegion setZRadius(double zRad) {
        this.zRad = zRad;
        return this;
    }

    @Override
    public Location getStart() {
        return this.center.clone().subtract(this.xRad, this.yRad, this.zRad);
    }

    @Override
    public Location getEnd() {
        return this.center.clone().add(this.xRad, this.yRad, this.zRad);
    }

    @Override
    public World getWorld() {
        return this.center.getWorld();
    }

    @Override
    public Location getCenter() {
        return this.center.clone();
    }

    public Location getSurfacePoint(Vector v) {
        v = v.clone().normalize();
        v.setX(v.getX() * this.xRad);
        v.setY(v.getY() * this.yRad);
        v.setZ(v.getZ() * this.zRad);
        return this.center.clone().add(v);
    }

    public Set<Block> getSurface() {
        if (this.surface == null) {
            this.surface = new HashSet<Block>();
            double inc = 45.0 / Math.max(this.zRad, Math.max(this.xRad, this.yRad));
            Location loc = this.getCenter();
            for (double pitch = 0.0; pitch < 360.0; pitch += inc) {
                for (double yaw = 0.0; yaw < 360.0; yaw += inc) {
                    loc.setPitch((float)pitch);
                    loc.setYaw((float)yaw);
                    Block toAdd = this.getSurfacePoint(loc.getDirection()).getBlock();
                    this.surface.add(toAdd);
                }
            }
        }
        return this.surface;
    }

    public boolean surfaceContains(Block block) {
        if (this.surface == null) {
            this.getSurface();
        }
        return this.surface.contains(block);
    }

    public String toString() {
        return LocationUtils.toString(this.center) + "-" + this.xRad + " " + this.yRad + " " + this.zRad;
    }

    public static SpheroidRegion fromString(String string) {
        String[] split = string.split("-");
        Location center = LocationUtils.fromString(split[0]);
        String[] radSplit = split[1].split(" ");
        double xRad = Double.parseDouble(radSplit[0]);
        double yRad = Double.parseDouble(radSplit[1]);
        double zRad = Double.parseDouble(radSplit[2]);
        return new SpheroidRegion(center, xRad, yRad, zRad);
    }
}

