/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import redempt.redlib.json.JSONList;
import redempt.redlib.json.JSONMap;
import redempt.redlib.json.JSONParser;

public class WeightedRandom<T> {
    private Map<T, Double> weights;
    private double total;
    private List<Double> totals;
    private List<T> items;

    public static <T> WeightedRandom<T> fromIntMap(Map<T, Integer> map) {
        HashMap dmap = new HashMap();
        map.forEach((k, v) -> dmap.put(k, Double.valueOf(v.intValue())));
        return new WeightedRandom(dmap, false);
    }

    public static <T> WeightedRandom<T> fromDoubleMap(Map<T, Double> map) {
        return new WeightedRandom<T>(map, false);
    }

    public static <T, K> WeightedRandom<T> fromCollection(Collection<K> collection, Function<K, T> converter, ToDoubleFunction<K> weightGetter) {
        HashMap<T, Double> map = new HashMap<T, Double>();
        for (K element : collection) {
            map.put(converter.apply(element), weightGetter.applyAsDouble(element));
        }
        return WeightedRandom.fromDoubleMap(map);
    }

    public WeightedRandom(Map<T, Integer> weights) {
        HashMap dmap = new HashMap();
        weights.forEach((k, v) -> dmap.put(k, Double.valueOf(v.intValue())));
        this.initialize(dmap);
    }

    public WeightedRandom() {
        this.weights = new HashMap<T, Double>();
        this.totals = new ArrayList<Double>();
        this.items = new ArrayList<T>();
        this.total = 0.0;
    }

    private WeightedRandom(Map<T, Double> weights, boolean no) {
        this.initialize(weights);
    }

    private void initialize(Map<T, Double> weights) {
        this.weights = weights;
        this.total = 0.0;
        this.totals = new ArrayList<Double>();
        this.items = new ArrayList<T>();
        int[] pos = new int[]{0};
        weights.forEach((k, v) -> {
            this.total += v.doubleValue();
            this.totals.add(this.total);
            this.items.add(k);
            pos[0] = pos[0] + 1;
        });
    }

    public T roll() {
        if (this.totals.size() == 0) {
            return null;
        }
        double random = Math.random() * this.total;
        int pos = Collections.binarySearch(this.totals, random);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        pos = Math.min(pos, this.items.size() - 1);
        return this.items.get(pos);
    }

    public Map<T, Double> getPercentages() {
        HashMap percentages = new HashMap();
        this.weights.forEach((k, v) -> percentages.put(k, v / this.total * 100.0));
        return percentages;
    }

    public Map<T, Double> getWeights() {
        return this.weights;
    }

    public void set(T outcome, int weight) {
        this.set(outcome, (double)weight);
    }

    public void set(T outcome, double weight) {
        this.remove(outcome);
        this.total += weight;
        this.weights.put(outcome, weight);
        this.totals.add(this.total);
        this.items.add(outcome);
    }

    public void remove(T outcome) {
        Double value = this.weights.remove(outcome);
        if (value == null) {
            return;
        }
        int index = this.items.indexOf(outcome);
        this.items.remove(index);
        this.totals.remove(index);
        this.total -= value.doubleValue();
        for (int i = index; i < this.totals.size(); ++i) {
            this.totals.set(i, this.totals.get(i) - value);
        }
    }

    public WeightedRandom<T> clone() {
        return new WeightedRandom<T>(new HashMap<T, Double>(this.weights), false);
    }

    public String toString(Function<T, String> converter) {
        JSONList list = new JSONList();
        this.weights.forEach((k, v) -> {
            JSONMap map = new JSONMap();
            map.put("weight", v);
            map.put("outcome", converter.apply(k));
            list.add(map);
        });
        return list.toString();
    }

    public static <T> WeightedRandom<T> fromString(String str, Function<String, T> converter) {
        JSONList list = JSONParser.parseList(str);
        HashMap<T, Double> map = new HashMap<T, Double>();
        for (int i = 0; i < list.size(); ++i) {
            JSONMap entry = list.getMap(i);
            T outcome = converter.apply(entry.getString("outcome"));
            double weight = entry.getDouble("weight");
            map.put(outcome, weight);
        }
        return WeightedRandom.fromDoubleMap(map);
    }

    public static <T> T roll(Map<T, Integer> map) {
        return new WeightedRandom<T>(map).roll();
    }
}

