/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.itemutils;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import redempt.redlib.itemutils.ItemUtils;

public class ItemBuilder
extends ItemStack {
    public ItemBuilder(Material material, int amount) {
        super(material, amount);
    }

    public ItemBuilder(Material material) {
        super(material);
    }

    public ItemBuilder(ItemStack item) {
        super(item);
    }

    public ItemBuilder setCount(int amount) {
        this.setAmount(amount);
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchant, int level) {
        ItemUtils.addEnchant(this, enchant, level);
        return this;
    }

    public ItemStack toItemStack() {
        return new ItemStack((ItemStack)this);
    }

    public ItemBuilder setLore(String ... lore) {
        ItemUtils.setLore((ItemStack)this, lore);
        return this;
    }

    public ItemBuilder addLore(String line) {
        ItemUtils.addLore((ItemStack)this, line);
        return this;
    }

    public ItemBuilder addLore(Iterable<String> lines) {
        ItemUtils.addLore((ItemStack)this, lines);
        return this;
    }

    public ItemBuilder setName(String name) {
        ItemUtils.rename(this, name);
        return this;
    }

    public ItemBuilder setDurability(int durability) {
        this.setDurability((short)durability);
        return this;
    }

    public ItemBuilder addAttribute(Attribute attribute, AttributeModifier modifier) {
        ItemUtils.addAttribute(this, attribute, modifier);
        return this;
    }

    public ItemBuilder addAttribute(Attribute attribute, double amount, AttributeModifier.Operation operation) {
        ItemUtils.addAttribute(this, attribute, amount, operation);
        return this;
    }

    public ItemBuilder addAttribute(Attribute attribute, double amount, AttributeModifier.Operation operation, EquipmentSlot slot) {
        ItemUtils.addAttribute(this, attribute, amount, operation, slot);
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... flags) {
        ItemUtils.addItemFlags(this, flags);
        return this;
    }

    public ItemBuilder addDamage(int damage) {
        ItemUtils.damage(this, damage);
        return this;
    }

    public ItemBuilder setCustomModelData(int customModelData) {
        ItemUtils.setCustomModelData(this, customModelData);
        return this;
    }

    public <T, Z> ItemBuilder addPersistentTag(NamespacedKey key, PersistentDataType<T, Z> type, Z data) {
        ItemUtils.addPersistentTag(this, key, type, data);
        return this;
    }

    public ItemBuilder unbreakable() {
        ItemUtils.setUnbreakable(this);
        return this;
    }
}

