/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.annotations.ConfigMappable;
import redempt.redlib.config.annotations.ConfigSubclassable;
import redempt.redlib.config.conversion.CollectionConverter;
import redempt.redlib.config.conversion.EnumConverter;
import redempt.redlib.config.conversion.MapConverter;
import redempt.redlib.config.conversion.NativeConverter;
import redempt.redlib.config.conversion.ObjectConverter;
import redempt.redlib.config.conversion.PrimitiveConverter;
import redempt.redlib.config.conversion.StringConverter;
import redempt.redlib.config.conversion.SubclassConverter;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.instantiation.Instantiator;

public class ConversionManager {
    private Map<ConfigType<?>, TypeConverter<?>> convertersByType;
    private Map<String, Class<?>> classesByName = new ConcurrentHashMap();
    private ClassLoader loader;

    public ConversionManager(Plugin plugin) {
        this.convertersByType = new HashMap();
        this.convertersByType.put(new ConfigType<String>(String.class), StringConverter.create(s -> s, s -> s));
        this.convertersByType.put(new ConfigType<Integer>(Integer.TYPE), PrimitiveConverter.create(Integer::parseInt, String::valueOf));
        this.convertersByType.put(new ConfigType<Double>(Double.TYPE), PrimitiveConverter.create(Double::parseDouble, String::valueOf));
        this.convertersByType.put(new ConfigType<Float>(Float.TYPE), PrimitiveConverter.create(Float::parseFloat, String::valueOf));
        this.convertersByType.put(new ConfigType<Boolean>(Boolean.TYPE), PrimitiveConverter.create(Boolean::parseBoolean, String::valueOf));
        this.convertersByType.put(new ConfigType<Long>(Long.TYPE), PrimitiveConverter.create(Long::parseLong, String::valueOf));
        this.convertersByType.put(new ConfigType<Integer>(Integer.class), PrimitiveConverter.create(Integer::parseInt, String::valueOf));
        this.convertersByType.put(new ConfigType<Double>(Double.class), PrimitiveConverter.create(Double::parseDouble, String::valueOf));
        this.convertersByType.put(new ConfigType<Float>(Float.class), PrimitiveConverter.create(Float::parseFloat, String::valueOf));
        this.convertersByType.put(new ConfigType<Boolean>(Boolean.class), PrimitiveConverter.create(Boolean::parseBoolean, String::valueOf));
        this.convertersByType.put(new ConfigType<Long>(Long.class), PrimitiveConverter.create(Long::parseLong, String::valueOf));
        this.loader = plugin.getClass().getClassLoader();
    }

    public Class<?> loadClass(String name) {
        return this.classesByName.computeIfAbsent(name, k -> {
            try {
                return Class.forName(k, true, this.loader);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public <T> TypeConverter<T> getConverter(ConfigType<T> type) {
        if (type == null) {
            return null;
        }
        TypeConverter<?> converter = this.convertersByType.get(type);
        if (converter == null) {
            converter = this.createConverter(type);
            this.convertersByType.put(type, converter);
        }
        return converter;
    }

    public <T> ConversionManager addConverter(Class<T> clazz, Function<String, T> loader, Function<T, String> saver) {
        this.convertersByType.put(new ConfigType<T>(clazz), StringConverter.create(loader, saver));
        return this;
    }

    public <T> ConversionManager addConverter(ConfigType<T> type, TypeConverter<T> converter) {
        this.convertersByType.put(type, converter);
        return this;
    }

    public <T> StringConverter<T> getStringConverter(ConfigType<T> type) {
        TypeConverter<T> keyConverter = this.getConverter(type);
        if (!(keyConverter instanceof StringConverter)) {
            throw new IllegalStateException("No appropriate string converter for key type " + type);
        }
        return (StringConverter)keyConverter;
    }

    private TypeConverter<?> createConverter(ConfigType<?> type) {
        if (Enum.class.isAssignableFrom(type.getType())) {
            return EnumConverter.create(type.getType());
        }
        if (Collection.class.isAssignableFrom(type.getType())) {
            return CollectionConverter.create(this, type);
        }
        if (Map.class.isAssignableFrom(type.getType())) {
            return MapConverter.create(this, type);
        }
        if (type.getType().isAnnotationPresent(ConfigMappable.class) || Instantiator.isRecord(type.getType())) {
            boolean isAbstract;
            Class<?> clazz = type.getType();
            boolean bl = isAbstract = clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers());
            if (isAbstract || clazz.isAnnotationPresent(ConfigSubclassable.class)) {
                return SubclassConverter.create(this, clazz, isAbstract);
            }
            return ObjectConverter.create(this, type);
        }
        return NativeConverter.create();
    }
}

