/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager.processing;

import java.util.function.Function;
import org.bukkit.command.CommandSender;
import redempt.redlib.commandmanager.ArgType;
import redempt.redlib.commandmanager.Constraint;
import redempt.redlib.commandmanager.processing.CommandParameter;

public class CommandArgument
implements CommandParameter {
    private ArgType<?> type;
    private String name;
    private Constraint<?> constraint;
    private boolean optional;
    private boolean hideType;
    private boolean consume;
    private boolean vararg;
    private boolean contextDefault = false;
    private Function<CommandSender, Object> defaultValue = null;
    public int pos;

    public CommandArgument(ArgType<?> type, int pos, String name, Constraint<?> constraint, boolean optional, boolean hideType, boolean consume, boolean vararg) {
        this.name = name;
        this.constraint = constraint;
        this.type = type;
        this.pos = pos;
        this.optional = optional;
        this.hideType = hideType;
        this.consume = consume;
        this.vararg = vararg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isContextDefault() {
        return this.contextDefault;
    }

    public void setDefaultValue(Function<CommandSender, Object> value, boolean context) {
        this.defaultValue = value;
        this.contextDefault = context;
    }

    public Object getDefaultValue(CommandSender sender) {
        return this.defaultValue == null ? null : this.defaultValue.apply(sender);
    }

    public Function<CommandSender, Object> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public String getTypeName() {
        String typeName = this.type.getName();
        if (this.vararg) {
            typeName = typeName + "[]";
        }
        if (this.consume) {
            typeName = typeName + "...";
        }
        return typeName;
    }

    @Override
    public ArgType<?> getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean consumes() {
        return this.consume;
    }

    public boolean isVararg() {
        return this.vararg;
    }

    @Override
    public Constraint<?> getConstraint() {
        return this.constraint;
    }

    public boolean takesAll() {
        return this.vararg || this.consume;
    }

    public String toString() {
        String name = this.hideType ? this.name : this.type.getName() + ":" + this.name;
        name = name + (this.vararg || this.consume ? "+" : "");
        name = this.optional ? "[" + name + "]" : "<" + name + ">";
        return name;
    }
}

