/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.nms;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.bukkit.Bukkit;
import redempt.redlib.nms.NMSClass;
import redempt.redlib.nms.NMSObject;

public class NMSHelper {
    private static String packageName = null;
    private static String version = null;

    public static String getNMSPackage() {
        if (packageName == null) {
            for (Package pkg : Package.getPackages()) {
                if (!pkg.getName().startsWith("net.minecraft.server.")) continue;
                packageName = pkg.getName();
                break;
            }
        }
        return packageName;
    }

    public static String getNMSVersion() {
        if (version == null) {
            String[] split = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
            version = split[split.length - 1];
        }
        return version;
    }

    public static void unwrapArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof NMSObject)) continue;
            args[i] = ((NMSObject)args[i]).getObject();
        }
    }

    public static Class<?>[] getArgTypes(Object ... args) {
        NMSHelper.unwrapArgs(args);
        Class[] classes = new Class[args.length];
        block16: for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof NMSObject) {
                classes[i] = ((NMSObject)args[i]).getObject().getClass();
                continue;
            }
            classes[i] = args[i].getClass();
            switch (classes[i].getSimpleName()) {
                case "Integer": {
                    classes[i] = Integer.TYPE;
                    continue block16;
                }
                case "Boolean": {
                    classes[i] = Boolean.TYPE;
                    continue block16;
                }
                case "Float": {
                    classes[i] = Float.TYPE;
                    continue block16;
                }
                case "Double": {
                    classes[i] = Double.TYPE;
                    continue block16;
                }
                case "Long": {
                    classes[i] = Long.TYPE;
                    continue block16;
                }
                case "Short": {
                    classes[i] = Short.TYPE;
                }
            }
        }
        return classes;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] argTypes) {
        Method[] methods;
        block0: for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(name) || method.getParameterCount() != argTypes.length) continue;
            Parameter[] params = method.getParameters();
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].getType().isAssignableFrom(argTypes[i])) continue block0;
            }
            return method;
        }
        return null;
    }

    public static Constructor getConstructor(Class<?> clazz, Class<?>[] argTypes) {
        Constructor<?>[] methods;
        block0: for (Constructor<?> method : methods = clazz.getConstructors()) {
            if (method.getParameterCount() != argTypes.length) continue;
            Parameter[] params = method.getParameters();
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].getType().isAssignableFrom(argTypes[i])) continue block0;
            }
            return method;
        }
        return null;
    }

    public static NMSClass getNMSClass(String name) {
        try {
            return new NMSClass(Class.forName(NMSHelper.getNMSPackage() + "." + name));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static NMSClass getClass(String name) {
        try {
            return new NMSClass(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

