/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.multiblock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import redempt.redlib.RedLib;
import redempt.redlib.multiblock.Rotator;
import redempt.redlib.multiblock.Structure;
import redempt.redlib.multiblock.StructureData;
import redempt.redlib.multiblock.StructureFinder;
import redempt.redlib.region.CuboidRegion;

public class MultiBlockStructure {
    protected StructureData[][][] data;
    private StructureFinder finder;
    private String dataString;
    private String name;
    protected int dimX;
    protected int dimY;
    protected int dimZ;
    protected boolean strictMode = true;
    protected boolean ignoreAir = false;
    protected EnumSet<Material> strictModeExclude = EnumSet.noneOf(Material.class);

    public static String stringify(Location start, Location end, Material skip) {
        if (!start.getWorld().equals(end.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same  world");
        }
        World world = start.getWorld();
        int minX = Math.min(start.getBlockX(), end.getBlockX());
        int minY = Math.min(start.getBlockY(), end.getBlockY());
        int minZ = Math.min(start.getBlockZ(), end.getBlockZ());
        int maxX = Math.max(start.getBlockX(), end.getBlockX());
        int maxY = Math.max(start.getBlockY(), end.getBlockY());
        int maxZ = Math.max(start.getBlockZ(), end.getBlockZ());
        String dims = maxX - minX + 1 + "x" + (maxY - minY + 1) + "x" + (maxZ - minZ + 1) + ";";
        ArrayList<String> parts = new ArrayList<String>();
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        int count = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = world.getBlockAt(x, y, z);
                    String block = MultiBlockStructure.stringify(b, skip);
                    int last = parts.size() - 1;
                    if (last >= 0 && block.equals(parts.get(last))) {
                        ++count;
                        continue;
                    }
                    counts.compute(block, (k, v) -> v == null ? 1 : v + 1);
                    if (count > 0) {
                        String part = (String)parts.get(last);
                        part = part + "*" + (count + 1);
                        parts.set(last, part);
                        count = 0;
                    }
                    parts.add(block);
                }
            }
        }
        if (count > 0) {
            int last = parts.size() - 1;
            String part = (String)parts.get(last);
            part = part + "*" + (count + 1);
            parts.set(last, part);
        }
        List replace = counts.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        counts.clear();
        IntStream.range(0, replace.size()).forEach(i -> counts.put((String)replace.get(i), i));
        String prefix = "";
        if (replace.size() > 0) {
            for (int i2 = 0; i2 < parts.size(); ++i2) {
                String part = (String)parts.get(i2);
                int ind = part.indexOf(42);
                String type = ind == -1 ? part : part.substring(0, ind);
                Integer index = (Integer)counts.get(type);
                if (index == null) continue;
                ind = ind == -1 ? part.length() : ind;
                part = index + part.substring(ind);
                parts.set(i2, part);
            }
            prefix = "(" + String.join((CharSequence)";", replace) + ")";
        }
        StringBuilder builder = new StringBuilder(prefix).append(dims);
        for (String part : parts) {
            builder.append(part).append(';');
        }
        return builder.substring(0, builder.length() - 1);
    }

    private static String stringify(Block block, Material skip) {
        Material type = block.getType();
        if (RedLib.MID_VERSION >= 13) {
            if (type == skip) {
                return "air";
            }
            String data = block.getBlockData().getAsString();
            if (data.length() > 9 && data.charAt(9) == ':') {
                data = data.substring(10);
            }
            return data;
        }
        return type + ":" + block.getData();
    }

    public static String stringify(Location start, Location end) {
        return MultiBlockStructure.stringify(start, end, null);
    }

    public static MultiBlockStructure create(String info, String name) {
        return new MultiBlockStructure(info, name, true, false);
    }

    public static MultiBlockStructure create(String info, String name, boolean strictMode) {
        return new MultiBlockStructure(info, name, strictMode, false);
    }

    public static MultiBlockStructure create(String info, String name, boolean strictMode, boolean ignoreAir) {
        return new MultiBlockStructure(info, name, strictMode, ignoreAir);
    }

    public static MultiBlockStructure create(InputStream stream, String name, boolean strictMode, boolean ignoreAir) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder combine = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                combine.append(line);
            }
            return MultiBlockStructure.create(combine.toString(), name, strictMode, ignoreAir);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MultiBlockStructure create(InputStream stream, String name, boolean strictMode) {
        return MultiBlockStructure.create(stream, name, strictMode, false);
    }

    public static MultiBlockStructure create(InputStream stream, String name) {
        return MultiBlockStructure.create(stream, name, true, false);
    }

    private static int findFromEnd(String str, char c) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private MultiBlockStructure(String info, String name, boolean strictMode, boolean ignoreAir) {
        this.dataString = info;
        this.name = name;
        this.strictMode = strictMode;
        this.ignoreAir = ignoreAir;
        this.parse(info);
        this.finder = new StructureFinder(this);
    }

    private void split(String s, char c, Consumer<String> callback) {
        int last = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            callback.accept(s.substring(last, i));
            last = i + 1;
        }
        if (last != s.length()) {
            callback.accept(s.substring(last));
        }
    }

    private void expand(String data, Consumer<StructureData> consumer) {
        StructureData[] replace = new StructureData[]{null};
        if (data.startsWith("(")) {
            String list = data.substring(1, data.indexOf(41));
            replace = (StructureData[])Arrays.stream(list.split(";")).map(StructureData::new).toArray(StructureData[]::new);
            data = data.substring(data.indexOf(41) + 1);
        }
        StructureData[] freplace = replace;
        boolean[] first = new boolean[]{true};
        this.split(data, ';', str -> {
            if (first[0]) {
                first[0] = false;
                int ind = MultiBlockStructure.findFromEnd(str, ')');
                String[] split = str.substring(ind + 1).split("x");
                this.dimX = Integer.parseInt(split[0]);
                this.dimY = Integer.parseInt(split[1]);
                this.dimZ = Integer.parseInt(split[2]);
                this.data = new StructureData[this.dimX][this.dimY][this.dimZ];
                return;
            }
            if (str.length() == 0) {
                return;
            }
            int ind = MultiBlockStructure.findFromEnd(str, '*');
            char c = str.charAt(0);
            String type = ind == -1 ? str : str.substring(0, ind);
            StructureData val = c >= '0' && c <= '9' ? freplace[Integer.parseInt(type)] : new StructureData(type);
            if (ind != -1) {
                int times = Integer.parseInt(str.substring(ind + 1));
                for (int i = 0; i < times; ++i) {
                    consumer.accept(val);
                }
                return;
            }
            consumer.accept(val);
        });
    }

    private void parse(String info) {
        int[] iter = new int[]{0, 0, 0};
        this.expand(info, s -> {
            this.data[iter[0]][iter[1]][iter[2]] = s;
            iter[2] = iter[2] + 1;
            if (iter[2] >= this.dimZ) {
                iter[2] = 0;
                iter[1] = iter[1] + 1;
                if (iter[1] >= this.dimY) {
                    iter[1] = 0;
                    iter[0] = iter[0] + 1;
                }
            }
        });
    }

    private void forEachData(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror, BiConsumer<Location, StructureData> callback) {
        loc = loc.getBlock().getLocation();
        Rotator rotator = new Rotator(rotation, mirror);
        for (int x = 0; x < this.dimX; ++x) {
            for (int y = 0; y < this.dimY; ++y) {
                for (int z = 0; z < this.dimZ; ++z) {
                    rotator.setLocation(x, z);
                    Location l = loc.clone().add((double)rotator.getRotatedBlockX(), (double)y, (double)rotator.getRotatedBlockZ());
                    rotator.setLocation(relX, relZ);
                    l.subtract((double)rotator.getRotatedBlockX(), (double)relY, (double)rotator.getRotatedBlockZ());
                    callback.accept(l, this.data[x][y][z].getRotated(rotator));
                }
            }
        }
    }

    public void addStrictModeExclusions(Material ... materials) {
        Collections.addAll(this.strictModeExclude, materials);
    }

    public Set<Material> getStrictModeExclusions() {
        return this.strictModeExclude;
    }

    public CuboidRegion getRegion(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror) {
        loc = loc.getBlock().getLocation();
        Rotator rotator = new Rotator(rotation, mirror);
        rotator.setLocation(relX, relZ);
        Location start = loc.clone().subtract((double)rotator.getRotatedBlockX(), (double)relY, (double)rotator.getRotatedBlockZ());
        rotator.setLocation(this.dimX, this.dimZ);
        Location end = start.clone().add((double)rotator.getRotatedBlockX(), (double)this.dimY, (double)rotator.getRotatedBlockZ());
        return new CuboidRegion(start, end);
    }

    public CuboidRegion getRegion(Location loc, int rotation, boolean mirror) {
        return this.getRegion(loc, 0, 0, 0, rotation, mirror);
    }

    public CuboidRegion getRegion(Location loc, int rotation) {
        return this.getRegion(loc, 0, 0, 0, rotation, false);
    }

    public CuboidRegion getRegion(Location loc) {
        return this.getRegion(loc, 0, 0, 0, 0, false);
    }

    public void forEachBlock(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror, Consumer<BlockState> callback) {
        this.forEachData(loc, relX, relY, relZ, rotation, mirror, (l, s) -> callback.accept(s.getState(l.getBlock())));
    }

    public BlockState getData(Location loc, int relX, int relY, int relZ) {
        if (relX >= this.dimX || relX < 0 || relY >= this.dimY || relY < 0 || relZ >= this.dimZ || relZ < 0) {
            return null;
        }
        return this.data[relX][relY][relZ].getState(loc.getBlock());
    }

    public BlockState getData(int relX, int relY, int relZ) {
        return this.getData(new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0), relX, relY, relZ);
    }

    public StructureData getStructureData(int relX, int relY, int relZ) {
        return this.data[relX][relY][relZ];
    }

    public Material getType(int relX, int relY, int relZ) {
        return this.getStructureData(relX, relY, relZ).getType();
    }

    public void forEachBlock(Location loc, int rotation, boolean mirror, Consumer<BlockState> callback) {
        this.forEachBlock(loc, 0, 0, 0, rotation, mirror, callback);
    }

    public void forEachBlock(Location loc, int rotation, Consumer<BlockState> callback) {
        this.forEachBlock(loc, 0, 0, 0, rotation, false, callback);
    }

    public void forEachBlock(Location loc, Consumer<BlockState> callback) {
        this.forEachBlock(loc, 0, 0, 0, 0, false, callback);
    }

    public boolean canBuild(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror, Predicate<Location> filter) {
        boolean[] canBuild = new boolean[]{true};
        this.forEachData(loc, relX, relY, relZ, rotation, mirror, (l, d) -> {
            if (!filter.test((Location)l)) {
                canBuild[0] = false;
            }
        });
        return canBuild[0];
    }

    public boolean canBuild(Location loc, int rotation, boolean mirror, Predicate<Location> filter) {
        return this.canBuild(loc, 0, 0, 0, rotation, mirror, filter);
    }

    public boolean canBuild(Location loc, int rotation, Predicate<Location> filter) {
        return this.canBuild(loc, 0, 0, 0, rotation, false, filter);
    }

    public boolean canBuild(Location loc, Predicate<Location> filter) {
        return this.canBuild(loc, 0, 0, 0, 0, false, filter);
    }

    public void visualize(Player player, Location loc, int relX, int relY, int relZ, int rotation, boolean mirror) {
        this.forEachData(loc, relX, relY, relZ, rotation, mirror, (l, d) -> d.sendBlock(player, (Location)l));
    }

    public void visualize(Player player, Location loc, int relX, int relY, int relZ) {
        this.visualize(player, loc, relX, relY, relZ, 0, false);
    }

    public Structure build(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror) {
        this.forEachData(loc, relX, relY, relZ, rotation, mirror, (l, d) -> {
            if (this.ignoreAir && d.isAir()) {
                return;
            }
            d.setBlock(l.getBlock());
        });
        return this.assumeAt(loc, relX, relY, relZ, rotation, mirror);
    }

    public Structure build(Location loc, int relX, int relY, int relZ) {
        return this.build(loc, relX, relY, relZ, 0, false);
    }

    public Structure build(Location loc, int relX, int relY, int relZ, int rotation) {
        return this.build(loc, relX, relY, relZ, rotation, false);
    }

    public Structure build(Location loc) {
        return this.build(loc, 0, 0, 0, 0, false);
    }

    public Structure build(Location loc, int rotation) {
        return this.build(loc, 0, 0, 0, rotation, false);
    }

    public int buildAsync(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror, int blocksPerTick, Consumer<Structure> callback) {
        Location location = loc.getBlock().getLocation();
        Rotator rotator = new Rotator(rotation, mirror);
        int[] iter = new int[]{0, 0, 0};
        int[] task = new int[]{0};
        task[0] = Bukkit.getScheduler().scheduleSyncRepeatingTask(RedLib.getInstance(), () -> {
            int pos = 0;
            while (iter[0] < this.dimX) {
                while (iter[1] < this.dimY) {
                    while (iter[2] < this.dimZ) {
                        rotator.setLocation(iter[0], iter[2]);
                        Location l = location.clone().add((double)rotator.getRotatedBlockX(), (double)iter[1], (double)rotator.getRotatedBlockZ());
                        rotator.setLocation(relX, relZ);
                        l.subtract((double)rotator.getRotatedBlockX(), (double)relY, (double)rotator.getRotatedBlockZ());
                        StructureData sdata = this.data[iter[0]][iter[1]][iter[2]].getRotated(rotator);
                        if (!this.ignoreAir || !sdata.isAir()) {
                            sdata.setBlock(l.getBlock());
                            ++pos;
                        }
                        if (pos >= blocksPerTick) {
                            return;
                        }
                        iter[2] = iter[2] + 1;
                    }
                    iter[2] = 0;
                    iter[1] = iter[1] + 1;
                }
                iter[1] = 0;
                iter[0] = iter[0] + 1;
            }
            try {
                callback.accept(this.assumeAt(location, relX, relY, relZ, rotation, mirror));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().cancelTask(task[0]);
        }, 1L, 1L);
        return task[0];
    }

    public int buildAsync(Location loc, int rotation, boolean mirror, int blocksPerTick, Consumer<Structure> callback) {
        return this.buildAsync(loc, 0, 0, 0, rotation, mirror, blocksPerTick, callback);
    }

    public int buildAsync(Location loc, int rotation, int blocksPerTick, Consumer<Structure> callback) {
        return this.buildAsync(loc, 0, 0, 0, rotation, false, blocksPerTick, callback);
    }

    public int buildAsync(Location loc, int blocksPerTick, Consumer<Structure> callback) {
        return this.buildAsync(loc, 0, 0, 0, 0, false, blocksPerTick, callback);
    }

    public String getName() {
        return this.name;
    }

    public int[] getDimensions() {
        return new int[]{this.dimX, this.dimY, this.dimZ};
    }

    public int getVolume() {
        return this.dimX * this.dimY * this.dimZ;
    }

    public boolean ignoresAir() {
        return this.ignoreAir;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public Structure getAt(Location loc) {
        return this.finder.getAt(loc.getBlock());
    }

    public Structure getAt(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror) {
        Structure s;
        Rotator rotator = new Rotator(rotation, mirror);
        this.data[relX][relY][relZ].getRotated(rotator).compare(loc.getBlock(), this.strictMode, this.ignoreAir);
        if (this.compare(this.data[relX][relY][relZ], loc.getBlock(), rotator) && (s = this.test(loc, relX, relY, relZ, rotator)) != null) {
            return s;
        }
        return null;
    }

    public Structure assumeAt(Location loc, int relX, int relY, int relZ, int rotation, boolean mirror) {
        loc = loc.getBlock().getLocation();
        Rotator rotator = new Rotator(rotation, mirror);
        rotator.setLocation(relX, relZ);
        loc.subtract((double)rotator.getRotatedBlockX(), (double)relY, (double)rotator.getRotatedBlockZ());
        return new Structure(this, loc, rotator);
    }

    public Structure assumeAt(Location loc, int rotation, boolean mirror) {
        return this.assumeAt(loc, 0, 0, 0, rotation, mirror);
    }

    public Structure assumeAt(Location loc, int rotation) {
        return this.assumeAt(loc, 0, 0, 0, rotation, false);
    }

    public Structure assumeAt(Location loc) {
        return this.assumeAt(loc, 0, 0, 0, 0, false);
    }

    private Structure test(Location loc, int xPos, int yPos, int zPos, Rotator rotator) {
        loc = loc.getBlock().getLocation();
        for (int x = 0; x < this.dimX; ++x) {
            for (int y = 0; y < this.dimY; ++y) {
                for (int z = 0; z < this.dimZ; ++z) {
                    rotator.setLocation(x - xPos, z - zPos);
                    int xp = rotator.getRotatedBlockX();
                    int yp = y - yPos;
                    int zp = rotator.getRotatedBlockZ();
                    Block block = loc.clone().add((double)xp, (double)yp, (double)zp).getBlock();
                    if (this.compare(this.data[x][y][z], block, rotator)) continue;
                    return null;
                }
            }
        }
        rotator.setLocation(xPos, zPos);
        loc = loc.clone().subtract((double)rotator.getRotatedBlockX(), (double)yPos, (double)rotator.getRotatedBlockZ());
        return new Structure(this, loc, rotator);
    }

    protected boolean compare(StructureData data, Block block, Rotator rotator) {
        return data.getRotated(rotator).compare(block, this.strictMode && !this.strictModeExclude.contains(data.getType()), this.ignoreAir);
    }

    public boolean equals(Object o) {
        if (o instanceof MultiBlockStructure) {
            MultiBlockStructure structure = (MultiBlockStructure)o;
            return structure.dataString.equals(this.dataString) && structure.name.equals(this.name);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.dataString, this.name);
    }

    public String toString() {
        return this.dataString;
    }
}

