/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.enchants;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import redempt.redlib.RedLib;
import redempt.redlib.commandmanager.ArgType;
import redempt.redlib.enchants.CustomEnchant;
import redempt.redlib.enchants.EnchantInfo;
import redempt.redlib.enchants.EventItems;
import redempt.redlib.enchants.trigger.EnchantTrigger;
import redempt.redlib.misc.EventListener;

public class EnchantRegistry {
    private static Map<Plugin, EnchantRegistry> registries = new HashMap<Plugin, EnchantRegistry>();
    private Map<String, CustomEnchant> enchants = new HashMap<String, CustomEnchant>();
    private Map<String, CustomEnchant> byDisplayName = new HashMap<String, CustomEnchant>();
    private Map<EnchantTrigger<?>, List<CustomEnchant>> triggers = new HashMap();
    private List<EventListener<?>> listeners = new ArrayList();
    private Plugin plugin;
    private Function<CustomEnchant, String> namer;

    public static EnchantRegistry get(Plugin plugin) {
        return registries.get(plugin);
    }

    public CustomEnchant getByName(String name) {
        return this.enchants.get(name.toLowerCase().replace(" ", "_"));
    }

    public Collection<CustomEnchant> getEnchants() {
        return this.enchants.values();
    }

    public EnchantRegistry(Plugin plugin, Function<CustomEnchant, String> namer) {
        this.plugin = plugin;
        this.namer = namer;
        registries.put(plugin, this);
    }

    public EnchantRegistry(Plugin plugin, String prefix) {
        this(plugin, (CustomEnchant e) -> prefix + e.getName());
    }

    public EnchantRegistry(Plugin plugin) {
        this(plugin, ChatColor.GRAY + "");
    }

    public void register(CustomEnchant ench) {
        if (this.enchants.containsKey(ench.getId())) {
            throw new IllegalArgumentException("Duplicate enchant ID/name " + ench.getId() + "/" + ench.getName());
        }
        ench.register(this);
        this.enchants.put(ench.getId(), ench);
        this.byDisplayName.put(ench.getDisplayName(), ench);
        ench.getTriggers().keySet().forEach(trigger -> {
            List<Object> enchs;
            if (this.triggers.containsKey(trigger)) {
                enchs = this.triggers.get(trigger);
            } else {
                enchs = new ArrayList();
                this.register((EnchantTrigger)trigger);
                this.triggers.put((EnchantTrigger<?>)trigger, (List<CustomEnchant>)enchs);
            }
            enchs.add(ench);
            this.triggers.put((EnchantTrigger<?>)trigger, (List<CustomEnchant>)enchs);
        });
    }

    private <T extends Event> void register(EnchantTrigger<T> trigger) {
        trigger.init();
        trigger.getEvents().forEach((c, it) -> this.listeners.add(new EventListener<Event>(this.plugin, (Class<Event>)c, trigger.getPriority(), e -> this.triggerEnchant((Function<Event, EventItems>)it, (Event)e, trigger))));
    }

    private <T extends Event> void triggerEnchant(Function<Event, EventItems> it, Event e, EnchantTrigger<T> trigger) {
        EventItems items = it.apply(e);
        if (items == null) {
            return;
        }
        for (CustomEnchant ench : this.triggers.get(trigger)) {
            for (int i = 0; i < items.getAfter().length; ++i) {
                int beforeLevel = ench.getLevel(items.getBefore()[i]);
                int afterLevel = ench.getLevel(items.getAfter()[i]);
                if (beforeLevel == 0 && afterLevel > 0) {
                    ench.getTriggers().get(trigger).activate(items.getEvent(), afterLevel);
                    continue;
                }
                if (beforeLevel > 0 && afterLevel == 0) {
                    ench.getTriggers().get(trigger).deactivate(items.getEvent(), beforeLevel);
                    continue;
                }
                if (beforeLevel == afterLevel) continue;
                ench.getTriggers().get(trigger).deactivate(items.getEvent(), beforeLevel);
                ench.getTriggers().get(trigger).activate(items.getEvent(), afterLevel);
            }
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void clear() {
        this.enchants.clear();
        this.byDisplayName.clear();
    }

    public void registerAll(Plugin plugin) {
        List<Class<CustomEnchant>> list = RedLib.getExtendingClasses(plugin, CustomEnchant.class);
        for (Class<CustomEnchant> clazz : list) {
            try {
                Constructor<CustomEnchant> constructor = clazz.getConstructor(new Class[0]);
                CustomEnchant ench = constructor.newInstance(new Object[0]);
                this.register(ench);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Class " + clazz.getName() + " does not have a default constructor or could not be loaded", e);
            }
        }
    }

    public Map<CustomEnchant, Integer> getEnchants(ItemStack item) {
        HashMap<CustomEnchant, Integer> map = new HashMap<CustomEnchant, Integer>();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return map;
        }
        item.getItemMeta().getLore().forEach(s -> {
            EnchantInfo info = this.fromLoreLine((String)s);
            if (info != null && info.getLevel() != 0) {
                map.putIfAbsent(info.getEnchant(), info.getLevel());
            }
        });
        return map;
    }

    public Map<CustomEnchant, Integer> combine(Map<CustomEnchant, Integer> first, Map<CustomEnchant, Integer> second) {
        HashMap<CustomEnchant, Integer> ffirst = new HashMap<CustomEnchant, Integer>(first);
        HashMap<CustomEnchant, Integer> fsecond = new HashMap<CustomEnchant, Integer>(second);
        fsecond.keySet().removeIf(e -> ffirst.keySet().stream().anyMatch(e2 -> !e2.isCompatible((CustomEnchant)e)));
        fsecond.forEach((ench, level) -> {
            if (!ffirst.containsKey(ench)) {
                ffirst.put((CustomEnchant)ench, (Integer)level);
                return;
            }
            int firstLevel = (Integer)ffirst.get(ench);
            if (firstLevel != level) {
                ffirst.put((CustomEnchant)ench, Math.max(level, firstLevel));
                return;
            }
            if (level + 1 <= ench.getMaxLevel()) {
                ffirst.put((CustomEnchant)ench, level + 1);
            }
        });
        return ffirst;
    }

    public ItemStack applyAll(Map<CustomEnchant, Integer> enchants, ItemStack item) {
        for (Map.Entry<CustomEnchant, Integer> entry : enchants.entrySet()) {
            item = entry.getKey().apply(item, entry.getValue());
        }
        return item;
    }

    public EnchantInfo fromLoreLine(String line) {
        int lastSpace = line.lastIndexOf(32);
        if (lastSpace != -1) {
            String name = line.substring(0, lastSpace);
            String level = line.substring(lastSpace + 1);
            CustomEnchant ench = this.byDisplayName.get(name);
            if (ench != null) {
                int lvl = CustomEnchant.fromRomanNumerals(level);
                return new EnchantInfo(ench, lvl);
            }
        }
        CustomEnchant ench = this.byDisplayName.get(line);
        if (ench != null && ench.getMaxLevel() == 1) {
            return new EnchantInfo(ench, 1);
        }
        return null;
    }

    public String getDisplayName(CustomEnchant enchant) {
        return this.namer.apply(enchant);
    }

    public ArgType<? extends CustomEnchant> getEnchantArgType(String name) {
        return new ArgType<CustomEnchant>(name, this::getByName).tabStream(c -> this.enchants.keySet().stream());
    }
}

