/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import redempt.redlib.config.ConversionManager;
import redempt.redlib.config.annotations.ConfigPath;
import redempt.redlib.config.instantiation.FieldSummary;
import redempt.redlib.config.instantiation.Instantiator;

public class ConstructorInstantiator
implements Instantiator {
    private Constructor<?> constructor;
    private Parameter[] params;

    public static <T> Instantiator createDefault(Class<?> clazz) {
        try {
            Field[] fields = clazz.getDeclaredFields();
            Constructor<?> constructor = clazz.getDeclaredConstructor((Class[])Arrays.stream(fields).map(Field::getType).toArray(Class[]::new));
            return new ConstructorInstantiator(constructor);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' does not have a constructor that takes all of its fields in order");
        }
    }

    private ConstructorInstantiator(Constructor<?> constructor) {
        this.constructor = constructor;
        this.params = constructor.getParameters();
    }

    @Override
    public <T> T instantiate(ConversionManager manager, Object target, Class<T> clazz, List<Object> values, String path, FieldSummary info) {
        Object[] objs = new Object[this.params.length];
        int valuePos = 0;
        for (int i = 0; i < this.params.length; ++i) {
            Parameter param = this.params[i];
            if (param.isAnnotationPresent(ConfigPath.class)) {
                objs[i] = info.getConfigPathConverter().fromString(path);
                continue;
            }
            objs[i] = values.get(valuePos);
            ++valuePos;
        }
        try {
            return (T)this.constructor.newInstance(objs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

