/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata.backend;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.plugin.Plugin;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.blockdata.ChunkPosition;
import redempt.redlib.blockdata.backend.PDCBackend;
import redempt.redlib.blockdata.backend.SQLiteBackend;

public interface BlockDataBackend {
    public static BlockDataBackend pdc(Plugin plugin) {
        return new PDCBackend(plugin);
    }

    public static BlockDataBackend sqlite(Path path) {
        return new SQLiteBackend(path);
    }

    public CompletableFuture<String> load(ChunkPosition var1);

    public CompletableFuture<Void> save(ChunkPosition var1, String var2);

    public CompletableFuture<Void> remove(ChunkPosition var1);

    public CompletableFuture<Void> saveAll();

    public CompletableFuture<Void> close();

    public CompletableFuture<Map<ChunkPosition, String>> loadAll();

    public boolean attemptMigration(BlockDataManager var1);
}

