/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.conversion;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.ConversionManager;
import redempt.redlib.config.conversion.StringConverter;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;

public class MapConverter {
    public static <K, V, M extends Map<K, V>> TypeConverter<M> create(ConversionManager manager, ConfigType<?> type) {
        List<ConfigType<?>> types = type.getComponentTypes();
        final StringConverter<?> keyConverter = manager.getStringConverter(types.get(0));
        final TypeConverter<?> valueConverter = manager.getConverter(types.get(1));
        return new TypeConverter<M>(){

            @Override
            public M loadFrom(DataHolder section, String path, M currentValue) {
                DataHolder newSection;
                if (currentValue == null) {
                    currentValue = new LinkedHashMap();
                } else {
                    currentValue.clear();
                }
                Object map = currentValue;
                DataHolder dataHolder = newSection = path == null ? section : section.getSubsection(path);
                if (newSection == null) {
                    return null;
                }
                newSection.getKeys().forEach(k -> {
                    Object key = keyConverter.fromString((String)k);
                    Object value = valueConverter.loadFrom(newSection, (String)k, null);
                    map.put(key, value);
                });
                return map;
            }

            @Override
            public void saveTo(M m, DataHolder section, String path) {
                DataHolder newSection;
                DataHolder dataHolder = newSection = path == null ? section : section.createSubsection(path);
                if (m == null) {
                    return;
                }
                m.forEach((k, v) -> {
                    String keyPath = keyConverter.toString(k);
                    valueConverter.saveTo(v, newSection, keyPath);
                });
            }
        };
    }
}

