/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import redempt.redlib.RedLib;

public class EventListener<T extends Event>
implements Listener {
    private BiConsumer<EventListener<T>, T> handler;
    private Class<T> eventClass;

    public EventListener(Class<T> eventClass, EventPriority priority, BiConsumer<EventListener<T>, T> handler) {
        this(RedLib.getCallingPlugin(), eventClass, priority, handler);
    }

    public EventListener(Plugin plugin, Class<T> eventClass, EventPriority priority, BiConsumer<EventListener<T>, T> handler) {
        this.handler = handler;
        this.eventClass = eventClass;
        Bukkit.getPluginManager().registerEvent(eventClass, (Listener)this, priority, (l, e) -> this.handleEvent(e), plugin);
    }

    public EventListener(Class<T> eventClass, EventPriority priority, Consumer<T> handler) {
        this(RedLib.getCallingPlugin(), eventClass, priority, handler);
    }

    public EventListener(Plugin plugin, Class<T> eventClass, EventPriority priority, Consumer<T> handler) {
        this(plugin, eventClass, priority, (EventListener<T> l, T e) -> handler.accept(e));
    }

    public EventListener(Class<T> eventClass, BiConsumer<EventListener<T>, T> handler) {
        this(RedLib.getCallingPlugin(), eventClass, handler);
    }

    public EventListener(Plugin plugin, Class<T> eventClass, BiConsumer<EventListener<T>, T> handler) {
        this(plugin, eventClass, EventPriority.NORMAL, handler);
    }

    public EventListener(Class<T> eventClass, Consumer<T> handler) {
        this(RedLib.getCallingPlugin(), eventClass, handler);
    }

    public EventListener(Plugin plugin, Class<T> eventClass, Consumer<T> handler) {
        this(plugin, eventClass, EventPriority.NORMAL, handler);
    }

    @EventHandler
    public void handleEvent(T event) {
        if (this.eventClass.isAssignableFrom(event.getClass())) {
            this.handler.accept(this, (EventListener)event);
        }
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }
}

