/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.multiblock;

import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.type.Wall;
import org.bukkit.util.Vector;
import redempt.redlib.RedLib;

public class Rotator {
    private static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private int rotation;
    private boolean mirrored;
    private double x = 0.0;
    private double z = 0.0;

    private static <T> int indexOf(T[] arr, T key) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    public static BlockFace rotateBlockFace(BlockFace face, int rotation, boolean mirror) {
        int ind;
        if ((rotation %= 4) < 0) {
            rotation += 4;
        }
        if ((ind = Rotator.indexOf(BLOCK_FACES, face)) == -1) {
            return face;
        }
        if (mirror && (ind == 1 || ind == 3)) {
            ind += 2;
        }
        ind = (ind + rotation) % 4;
        return BLOCK_FACES[ind];
    }

    public static BlockFace rotateBlockFace(BlockFace face, int rotation) {
        return Rotator.rotateBlockFace(face, rotation, false);
    }

    public Rotator(int rotation, boolean mirrored) {
        while (rotation < 0) {
            rotation += 4;
        }
        this.rotation = rotation % 4;
        this.mirrored = mirrored;
    }

    public BlockData rotate(BlockData data) {
        int i;
        Directional d;
        if ((data = data.clone()) instanceof Directional) {
            d = (Directional)data;
            BlockFace face = this.rotateBlockFace(d.getFacing());
            d.setFacing(face);
        }
        if (data instanceof MultipleFacing) {
            d = (MultipleFacing)data;
            Boolean[] directions = new Boolean[4];
            for (i = 0; i < 4; ++i) {
                directions[i] = d.hasFace(BLOCK_FACES[i]);
            }
            this.rotate(directions);
            for (i = 0; i < 4; ++i) {
                d.setFace(BLOCK_FACES[i], directions[i].booleanValue());
            }
        }
        if (data instanceof Orientable) {
            d = (Orientable)data;
            if (this.rotation % 2 != 0 && d.getAxis() != Axis.Y) {
                d.setAxis(d.getAxis() == Axis.X ? Axis.Z : Axis.X);
            }
        }
        if (RedLib.MID_VERSION >= 16 && data instanceof Wall) {
            d = (Wall)data;
            Wall.Height[] heights = new Wall.Height[4];
            for (i = 0; i < 4; ++i) {
                heights[i] = d.getHeight(BLOCK_FACES[i]);
            }
            this.rotate(heights);
            for (i = 0; i < 4; ++i) {
                d.setHeight(BLOCK_FACES[i], heights[i]);
            }
        }
        return data;
    }

    private <T> void rotate(T[] arr) {
        int i;
        Object[] rot = new Object[4];
        for (i = 0; i < 4; ++i) {
            rot[i] = arr[i];
        }
        for (i = 0; i < 4; ++i) {
            int dir = (i + 4 - this.rotation) % 4;
            arr[i] = rot[dir];
        }
        if (this.mirrored) {
            int first = this.rotation % 2 == 0 ? 1 : 0;
            int second = this.rotation % 2 == 0 ? 3 : 2;
            T tmp = arr[first];
            arr[first] = arr[second];
            arr[second] = tmp;
        }
    }

    public BlockFace rotateBlockFace(BlockFace face) {
        return Rotator.rotateBlockFace(face, this.rotation, this.mirrored);
    }

    public Vector rotateVector(Vector vector) {
        this.setLocation(vector.getX(), vector.getZ());
        return new Vector(this.getRotatedX(), vector.getY(), this.getRotatedZ());
    }

    public void setLocation(double x, double z) {
        this.x = this.mirrored ? -x : x;
        this.z = z;
    }

    public int getRotatedBlockX() {
        return (int)this.getRotatedX();
    }

    public int getRotatedBlockZ() {
        return (int)this.getRotatedZ();
    }

    public double getRotatedX() {
        switch (this.rotation) {
            case 0: {
                return this.x;
            }
            case 1: {
                return -this.z;
            }
            case 2: {
                return -this.x;
            }
            case 3: {
                return this.z;
            }
        }
        return 0.0;
    }

    public double getRotatedZ() {
        switch (this.rotation) {
            case 0: {
                return this.z;
            }
            case 1: {
                return this.x;
            }
            case 2: {
                return -this.z;
            }
            case 3: {
                return -this.x;
            }
        }
        return 0.0;
    }

    public Rotator getInverse() {
        return new Rotator(-this.rotation, this.mirrored);
    }

    public Rotator clone() {
        return new Rotator(this.rotation, this.mirrored);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation % 4;
    }

    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }
}

