/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class FormatUtils {
    private static DecimalFormat format = new DecimalFormat("0.00");
    private static char[] suffixes = new char[]{'K', 'M', 'B', 'T', 'Q'};
    private static Set<Character> colorChars = "4c6e2ab319d5f780rlonmk".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toSet());

    public static String formatTimeOffset(long millis, int truncate) {
        long days = (millis /= 1000L) / 86400L;
        long hours = (millis %= 86400L) / 3600L;
        long minutes = (millis %= 3600L) / 60L;
        millis %= 60L;
        StringBuilder output = new StringBuilder();
        if (days > 0L || truncate == 3) {
            output.append(days).append("d");
        }
        if (hours > 0L && (truncate < 3 || days == 0L)) {
            output.append(hours).append("h");
        }
        if (minutes > 0L && (truncate < 2 || hours == 0L)) {
            output.append(minutes).append("m");
        }
        if (truncate < 1) {
            output.append(millis).append("s");
        }
        return output.toString();
    }

    public static String formatTimeOffset(long millis) {
        return FormatUtils.formatTimeOffset(millis, 0);
    }

    public static String truncateDouble(double input) {
        return format.format(input);
    }

    public static String color(String input) {
        return FormatUtils.color(input, true);
    }

    public static String color(String input, boolean hex) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            String hexCode;
            char c = input.charAt(i);
            if (i + 1 >= input.length()) {
                builder.append(c);
                continue;
            }
            char n = input.charAt(i + 1);
            if (c == '\\' && (n == '&' || n == '\\')) {
                ++i;
                builder.append(n);
                continue;
            }
            if (c != '&') {
                builder.append(c);
                continue;
            }
            if (colorChars.contains(Character.valueOf(n))) {
                builder.append('\u00a7');
                continue;
            }
            if (hex && n == '#' && i + 7 <= input.length() && (hexCode = input.substring(i + 2, i + 8).toUpperCase(Locale.ROOT)).chars().allMatch(ch -> ch <= 57 && ch >= 48 || ch <= 70 && ch >= 65)) {
                hexCode = Arrays.stream(hexCode.split("")).map(s -> '\u00a7' + s).collect(Collectors.joining());
                builder.append('\u00a7').append("x").append(hexCode);
                i += 7;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String formatMoney(double money) {
        int i = -1;
        while (money >= 1000.0) {
            money /= 1000.0;
            ++i;
        }
        if (i >= 0) {
            return FormatUtils.truncateDouble(money) + suffixes[i];
        }
        return FormatUtils.truncateDouble(money);
    }

    public static String formatLargeInteger(long num) {
        if (num == 0L) {
            return "0";
        }
        StringBuilder out = new StringBuilder();
        boolean negative = num < 0L;
        int iter = 0;
        for (num = Math.abs(num); num > 0L; num /= 10L) {
            out.append(num % 10L);
            if (++iter != 3) continue;
            iter = 0;
            out.append(',');
        }
        if (negative) {
            out.append('-');
        }
        out.reverse();
        if (out.charAt(0) == ',') {
            out.deleteCharAt(0);
        }
        return out.toString();
    }

    public static String toTitleCase(String string) {
        StringBuilder str = new StringBuilder();
        boolean space = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            str.append(space ? Character.toUpperCase(c) : Character.toLowerCase(c));
            space = c == ' ';
        }
        return str.toString();
    }

    public static String toCamelCase(String string) {
        StringBuilder str = new StringBuilder();
        boolean space = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            str.append(c == ' ' ? "" : Character.valueOf(space ? Character.toUpperCase(c) : Character.toLowerCase(c)));
            space = c == ' ';
        }
        return str.toString();
    }

    public static List<String> lineWrap(String line, int maxLength) {
        String[] split = line.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (String word : split) {
            if (current.length() + word.length() + 1 <= maxLength) {
                current.append(word).append(' ');
                continue;
            }
            if (current.length() > 0) {
                lines.add(current.substring(0, current.length() - 1));
            }
            current = new StringBuilder(word).append(' ');
        }
        if (current.length() > 0) {
            lines.add(current.substring(0, current.length() - 1));
        }
        return lines;
    }
}

