/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.ConversionManager;
import redempt.redlib.config.conversion.ObjectConverter;
import redempt.redlib.config.conversion.StaticRootConverter;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.ConfigurationSectionDataHolder;

public class ConfigManager {
    private static Boolean commentsSupported;
    private FileConfiguration config;
    private ConfigurationSectionDataHolder holder;
    private File file;
    private TypeConverter<?> converter;
    private Object target;
    private Class<?> targetClass;
    private ConversionManager conversionManager;

    public static boolean areCommentsSupported() {
        if (commentsSupported == null) {
            commentsSupported = Arrays.stream(ConfigurationSection.class.getMethods()).anyMatch(m -> m.getName().equals("setComments"));
        }
        return commentsSupported;
    }

    public static ConfigManager create(Plugin plugin, File file) {
        return new ConfigManager(plugin, file);
    }

    public static ConfigManager create(Plugin plugin, Path path) {
        return ConfigManager.create(plugin, path.toFile());
    }

    public static ConfigManager create(Plugin plugin, String configName) {
        return ConfigManager.create(plugin, plugin.getDataFolder().toPath().resolve(configName));
    }

    public static ConfigManager create(Plugin plugin) {
        return ConfigManager.create(plugin, "config.yml");
    }

    private ConfigManager(Plugin plugin, File file) {
        this.conversionManager = new ConversionManager(plugin);
        this.file = file;
        file.getParentFile().mkdirs();
        if (file.exists()) {
            this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        } else {
            this.setConfig((FileConfiguration)new YamlConfiguration());
        }
    }

    public ConversionManager getConversionManager() {
        return this.conversionManager;
    }

    public void setConversionManager(ConversionManager conversionManager) {
        this.conversionManager = conversionManager;
    }

    public <T> ConfigManager addConverter(Class<T> clazz, Function<String, T> loader, Function<T, String> saver) {
        this.conversionManager.addConverter(clazz, loader, saver);
        return this;
    }

    public <T> ConfigManager addConverter(ConfigType<T> type, TypeConverter<T> converter) {
        this.conversionManager.addConverter(type, converter);
        return this;
    }

    private void setConfig(FileConfiguration config) {
        this.config = config;
        this.holder = new ConfigurationSectionDataHolder((ConfigurationSection)config);
    }

    public ConfigManager target(Object obj) {
        if (this.target != null || this.targetClass != null) {
            throw new IllegalStateException("ConfigManager already has a target");
        }
        this.target = obj;
        this.converter = ObjectConverter.create(this.conversionManager, new ConfigType(obj.getClass()));
        return this;
    }

    public ConfigManager target(Class<?> clazz) {
        if (this.target != null || this.targetClass != null) {
            throw new IllegalStateException("ConfigManager already has a target");
        }
        this.targetClass = clazz;
        this.converter = StaticRootConverter.create(this.conversionManager, clazz);
        return this;
    }

    public ConfigManager save() {
        this.save(this.converter, true);
        return this;
    }

    public ConfigManager saveDefaults() {
        this.save(this.converter, false);
        return this;
    }

    public ConfigManager load() {
        this.load(this.converter);
        return this;
    }

    private <T> void load(TypeConverter<T> converter) {
        converter.loadFrom(this.holder, null, this.target);
    }

    public ConfigManager reload() {
        this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)this.file));
        return this.load();
    }

    private <T> void save(TypeConverter<T> converter, boolean overwrite) {
        this.holder.clearComments();
        converter.saveTo(this.target, this.holder, null, overwrite);
        if (ConfigManager.areCommentsSupported()) {
            this.holder.getComments().forEach((arg_0, arg_1) -> ((FileConfiguration)this.config).setComments(arg_0, arg_1));
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

