/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import redempt.redlib.RedLib;
import redempt.redlib.misc.LocationUtils;
import redempt.redlib.protection.ProtectedRegion;
import redempt.redlib.protection.ProtectionPolicy;
import redempt.redlib.region.CuboidRegion;
import redempt.redlib.region.RegionEnterExitListener;

public abstract class Region
implements Cloneable {
    public abstract Location getStart();

    public abstract Location getEnd();

    public abstract double getVolume();

    public abstract int getBlockVolume();

    public abstract Region expand(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract Region expand(BlockFace var1, double var2);

    public abstract Region move(Vector var1);

    public abstract Region move(double var1, double var3, double var5);

    public abstract boolean contains(Location var1);

    public abstract Region clone();

    public abstract Region rotate(Location var1, int var2);

    public abstract Region setWorld(World var1);

    public abstract Stream<Block> stream();

    public Set<Chunk> getChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        int[] cstart = LocationUtils.getChunkCoordinates(this.getStart());
        int[] cend = LocationUtils.getChunkCoordinates(this.getEnd());
        for (int cx = cstart[0]; cx <= cend[0]; ++cx) {
            for (int cz = cstart[1]; cz <= cend[1]; ++cz) {
                chunks.add(this.getWorld().getChunkAt(cx, cz));
            }
        }
        return chunks;
    }

    public boolean contains(Block block) {
        return this.contains(block.getLocation());
    }

    public Set<Chunk> getLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        int[] cstart = LocationUtils.getChunkCoordinates(this.getStart());
        int[] cend = LocationUtils.getChunkCoordinates(this.getEnd());
        for (int cx = cstart[0]; cx <= cend[0]; ++cx) {
            for (int cz = cstart[1]; cz <= cend[1]; ++cz) {
                if (!this.getStart().getWorld().isChunkLoaded(cx, cz)) continue;
                chunks.add(this.getStart().getWorld().getChunkAt(cx, cz));
            }
        }
        return chunks;
    }

    public void enableEvents() {
        RegionEnterExitListener.getRegionMap().set(this.toCuboid(), this);
    }

    public void disableEvents() {
        RegionEnterExitListener.getRegionMap().remove(this.toCuboid(), this);
    }

    public List<Player> getPlayers() {
        return this.getEntities(false).stream().filter(e -> e instanceof Player).map(e -> (Player)e).collect(Collectors.toList());
    }

    public List<Entity> getEntities() {
        return this.getEntities(false);
    }

    public List<Entity> getEntities(boolean load) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Stream chunkStream = load ? this.getChunks().stream() : this.getLoadedChunks().stream();
        chunkStream.map(Chunk::getEntities).forEach(e -> Arrays.stream(e).filter(en -> this.contains(en.getLocation())).forEach(entities::add));
        return entities;
    }

    public World getWorld() {
        return this.getStart().getWorld();
    }

    public void forEachBlock(Consumer<Block> forEach) {
        this.stream().forEach(forEach);
    }

    public int[] getBlockDimensions() {
        return new int[]{this.getEnd().getBlockX() - this.getStart().getBlockX(), this.getEnd().getBlockY() - this.getStart().getBlockY(), this.getEnd().getBlockZ() - this.getStart().getBlockZ()};
    }

    public double[] getDimensions() {
        return new double[]{this.getEnd().getX() - this.getStart().getX(), this.getEnd().getY() - this.getStart().getY(), this.getEnd().getZ() - this.getStart().getZ()};
    }

    public Location[] getCorners() {
        Location start = this.getStart();
        Location end = this.getEnd();
        return new Location[]{start, end, new Location(this.getWorld(), start.getX(), start.getY(), end.getZ()), new Location(this.getWorld(), start.getX(), end.getY(), start.getZ()), new Location(this.getWorld(), end.getX(), start.getY(), start.getZ()), new Location(this.getWorld(), start.getX(), end.getY(), end.getZ()), new Location(this.getWorld(), end.getX(), end.getY(), start.getZ()), new Location(this.getWorld(), end.getX(), start.getY(), end.getZ())};
    }

    public CuboidRegion toCuboid() {
        return new CuboidRegion(this.getStart().clone(), this.getEnd().clone());
    }

    public Location getCenter() {
        return this.getStart().clone().add(this.getEnd()).multiply(0.5);
    }

    public ProtectedRegion protect(Plugin plugin, ProtectionPolicy.ProtectionType ... types) {
        return new ProtectedRegion(plugin, this, types);
    }

    public ProtectedRegion protect(ProtectionPolicy.ProtectionType ... types) {
        return this.protect(RedLib.getCallingPlugin(), types);
    }

    public double measure(BlockFace direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                return this.getDimensions()[1];
            }
            case EAST: 
            case WEST: {
                return this.getDimensions()[0];
            }
            case NORTH: 
            case SOUTH: {
                return this.getDimensions()[2];
            }
        }
        throw new IllegalArgumentException("Face must be one of UP, DOWN, NORTH, SOUTH, EAST, or WEST");
    }

    public int measureBlocks(BlockFace direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                return this.getBlockDimensions()[1];
            }
            case EAST: 
            case WEST: {
                return this.getBlockDimensions()[0];
            }
            case NORTH: 
            case SOUTH: {
                return this.getBlockDimensions()[2];
            }
        }
        throw new IllegalArgumentException("Face must be one of UP, DOWN, NORTH, SOUTH, EAST, or WEST");
    }
}

