/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.multiblock;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import redempt.redlib.multiblock.MultiBlockStructure;
import redempt.redlib.multiblock.Rotator;
import redempt.redlib.region.CuboidRegion;

public class Structure {
    private MultiBlockStructure type;
    private Location loc;
    private Rotator rotator;

    protected Structure(MultiBlockStructure type, Location loc, Rotator rotator) {
        this.type = type;
        this.loc = loc;
        this.rotator = rotator;
    }

    public MultiBlockStructure getType() {
        return this.type;
    }

    public Location getLocation() {
        return this.loc;
    }

    public Rotator getRotator() {
        return this.rotator.clone();
    }

    public List<StructureBlock> getByType(Material type) {
        return this.getBlocks().stream().filter(s -> s.getBlock().getType() == type).collect(Collectors.toList());
    }

    public List<StructureBlock> getBlocks() {
        ArrayList<StructureBlock> blocks = new ArrayList<StructureBlock>();
        int[] dimensions = this.type.getDimensions();
        for (int x = 0; x < dimensions[0]; ++x) {
            for (int y = 0; y < dimensions[1]; ++y) {
                for (int z = 0; z < dimensions[2]; ++z) {
                    this.rotator.setLocation(x, z);
                    Block b = this.loc.getWorld().getBlockAt(this.rotator.getRotatedBlockX() + this.loc.getBlockX(), y + this.loc.getBlockY(), this.rotator.getRotatedBlockZ() + this.loc.getBlockZ());
                    blocks.add(new StructureBlock(b, this, x, y, z));
                }
            }
        }
        return blocks;
    }

    public boolean isIntact() {
        return this.type.getAt(this.loc, 0, 0, 0, this.rotator.getRotation(), this.rotator.isMirrored()) != null;
    }

    public CuboidRegion getRegion() {
        int[] dim = this.getType().getDimensions();
        Location loc = this.getRelative(dim[0] - 1, dim[1] - 1, dim[2] - 1).getBlock().getLocation();
        return new CuboidRegion(this.loc, loc).expand(1.0, 0.0, 1.0, 0.0, 1.0, 0.0);
    }

    public StructureBlock getRelative(int x, int y, int z) {
        int[] dim = this.type.getDimensions();
        if (x < 0 || y < 0 || z < 0 || x >= dim[0] || y >= dim[1] || z >= dim[2]) {
            throw new IndexOutOfBoundsException("Relative location outside bounds of structure: " + x + ", " + y + ", " + z);
        }
        this.rotator.setLocation(x, z);
        return new StructureBlock(this.loc.getWorld().getBlockAt(this.rotator.getRotatedBlockX() + this.loc.getBlockX(), y + this.loc.getBlockY(), this.rotator.getRotatedBlockZ() + this.loc.getBlockZ()), this, x, y, z);
    }

    public StructureBlock getBlock(Block block) {
        if (!block.getWorld().equals((Object)this.loc.getWorld())) {
            return null;
        }
        Location offset = block.getLocation().subtract(this.loc);
        Rotator rotator = this.rotator.getInverse();
        rotator.setMirrored(false);
        int[] dim = this.type.getDimensions();
        rotator.setLocation(offset.getBlockX(), offset.getBlockZ());
        int x = rotator.getRotatedBlockX();
        int y = offset.getBlockY();
        int z = rotator.getRotatedBlockZ();
        if (this.getRotator().isMirrored()) {
            if (this.getRotator().getRotation() % 2 != 0) {
                x *= -1;
            } else {
                z *= -1;
            }
        }
        if (x < 0 || y < 0 || z < 0 || x >= dim[0] || y >= dim[1] || z >= dim[2]) {
            return null;
        }
        return new StructureBlock(block, this, x, y, z);
    }

    public static class StructureBlock {
        private int relX;
        private int relY;
        private int relZ;
        private Block block;
        private Structure structure;

        private StructureBlock(Block block, Structure structure, int relX, int relY, int relZ) {
            this.relX = relX;
            this.relY = relY;
            this.relZ = relZ;
            this.block = block;
            this.structure = structure;
        }

        public int[] getRelativeCoordinates() {
            return new int[]{this.relX, this.relY, this.relZ};
        }

        public BlockState getStructureData() {
            return this.structure.getType().getData(this.block.getLocation(), this.relX, this.relY, this.relZ);
        }

        public Material getStructureType() {
            return this.structure.getType().getType(this.relX, this.relY, this.relZ);
        }

        public int getRelativeX() {
            return this.relX;
        }

        public int getRelativeY() {
            return this.relY;
        }

        public int getRelativeZ() {
            return this.relZ;
        }

        public Structure getStructure() {
            return this.structure;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

