/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.dev.profiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import redempt.redlib.dev.profiler.Sample;

public class SampleSummary {
    private List<Sample> samples = new ArrayList<Sample>();
    private Map<String, List<SampleMethod>> methods = new ConcurrentHashMap<String, List<SampleMethod>>();
    private SampleMethod root;
    private long end;
    private long start;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SampleMethod getSampleMethod(StackTraceElement elem, SampleMethod parent) {
        String name = SampleSummary.getName(elem);
        List<SampleMethod> methods = this.methods.get(name);
        if (methods == null) {
            methods = Collections.synchronizedList(new ArrayList());
            SampleMethod method = new SampleMethod(this, name);
            if (parent != null) {
                parent.addChild(method);
            }
            methods.add(method);
            this.methods.put(name, methods);
            return method;
        }
        Object method = methods;
        synchronized (method) {
            for (SampleMethod method2 : methods) {
                if (!method2.getName().equals(name) || method2.parent != parent) continue;
                return method2;
            }
        }
        method = new SampleMethod(this, name);
        if (parent != null) {
            parent.addChild((SampleMethod)method);
        }
        methods.add((SampleMethod)method);
        return method;
    }

    protected SampleSummary(Collection<Sample> samples) {
        if (samples.size() == 0) {
            this.samples = null;
            this.start = System.currentTimeMillis();
            this.end = System.currentTimeMillis();
            return;
        }
        this.samples.addAll(samples);
        for (Sample sample : samples) {
            StackTraceElement[] stack = sample.getStackTrace();
            this.add(stack);
        }
    }

    protected SampleSummary() {
        this.start = System.currentTimeMillis();
    }

    protected void add(StackTraceElement[] stack) {
        this.end = System.currentTimeMillis();
        SampleMethod parent = null;
        int i = stack.length - 1;
        if (this.root == null) {
            StackTraceElement root = stack[stack.length - 1];
            parent = this.root = this.getSampleMethod(root, null);
            this.root.increment();
            --i;
        }
        while (i >= 0) {
            StackTraceElement elem = stack[i];
            SampleMethod method = this.getSampleMethod(elem, parent);
            method.increment();
            parent = method;
            --i;
        }
    }

    public SampleSummary clone() {
        SampleSummary clone = new SampleSummary();
        if (this.root == null) {
            return clone;
        }
        HashMap<String, List<SampleMethod>> methods = new HashMap<String, List<SampleMethod>>();
        SampleMethod root = this.root.clone(clone);
        ArrayDeque<SampleMethod> deque = new ArrayDeque<SampleMethod>();
        deque.add(root);
        while (deque.size() > 0) {
            SampleMethod method = (SampleMethod)deque.poll();
            deque.addAll(method.getChildren());
            ArrayList<SampleMethod> list = (ArrayList<SampleMethod>)methods.get(method.getName());
            if (list == null) {
                list = new ArrayList<SampleMethod>();
                list.add(method);
                methods.put(method.getName(), list);
                continue;
            }
            list.add(method);
        }
        clone.methods = methods;
        clone.root = root;
        return clone;
    }

    public long getStart() {
        return this.samples == null ? this.start : this.samples.get(0).getTime();
    }

    public long getEnd() {
        return this.samples == null ? this.end : this.samples.get(this.samples.size() - 1).getTime();
    }

    public long getDuration() {
        return this.getEnd() - this.getStart();
    }

    public SampleMethod getRoot() {
        return this.root;
    }

    public Map<String, List<SampleMethod>> getMethodsByName() {
        return this.methods;
    }

    private static String getName(StackTraceElement elem) {
        return elem.getClassName() + '#' + elem.getMethodName();
    }

    public static class SampleMethod {
        private String name;
        private String shortName;
        private long count = 1L;
        private int depth = 0;
        protected SampleMethod parent = null;
        private Set<SampleMethod> children = new HashSet<SampleMethod>();
        protected SampleSummary summary;

        protected SampleMethod(SampleSummary summary, String name) {
            this.name = name;
            this.summary = summary;
        }

        public double getPrevalence() {
            return (double)this.count / (double)((SampleSummary)this.summary).root.count * 100.0;
        }

        public SampleMethod getParent() {
            return this.parent;
        }

        public Set<SampleMethod> getChildren() {
            return this.children;
        }

        public String getName() {
            return this.name;
        }

        public int getDepth() {
            return this.depth;
        }

        public String getShortName() {
            if (this.shortName != null) {
                return this.shortName;
            }
            this.shortName = this.name.substring(this.name.lastIndexOf(46) + 1);
            int index = this.shortName.indexOf(47);
            if (index != -1) {
                this.shortName = this.shortName.substring(0, index) + this.shortName.substring(this.shortName.indexOf(35));
            }
            return this.shortName;
        }

        protected void addChild(SampleMethod method) {
            this.children.add(method);
            method.parent = this;
            method.depth = this.depth + 1;
        }

        protected void increment() {
            ++this.count;
        }

        public long getCount() {
            return this.count;
        }

        protected SampleMethod clone(SampleSummary summary) {
            SampleMethod root = new SampleMethod(summary, this.name);
            root.count = this.count;
            root.depth = this.depth;
            for (SampleMethod method : this.children) {
                root.addChild(method.clone(summary));
            }
            return root;
        }
    }
}

