/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.blockdata.BlockPosition;
import redempt.redlib.blockdata.ChunkPosition;
import redempt.redlib.json.JSONList;
import redempt.redlib.json.JSONMap;

public class DataBlock {
    protected JSONMap data;
    private BlockDataManager manager;
    private BlockPosition block;
    private String world;
    private Map<String, Object> transientProperties;

    DataBlock(JSONMap data, BlockPosition block, String world, BlockDataManager manager) {
        this.data = data;
        this.block = block;
        this.manager = manager;
        this.world = world;
    }

    public BlockDataManager getManager() {
        return this.manager;
    }

    public Map<String, Object> getTransientProperties() {
        if (this.transientProperties == null) {
            this.transientProperties = new HashMap<String, Object>();
        }
        return this.transientProperties;
    }

    public Block getBlock() {
        return Bukkit.getWorld((String)this.world).getBlockAt(this.block.getX(), this.block.getY(), this.block.getZ());
    }

    protected ChunkPosition getChunkPosition() {
        return new ChunkPosition(this.block, this.world);
    }

    protected BlockPosition getBlockPosition() {
        return this.block;
    }

    public Object getObject(String key) {
        return this.data.get(key);
    }

    public String getString(String key) {
        return this.data.getString(key);
    }

    public Integer getInt(String key) {
        return this.data.getInt(key);
    }

    public Long getLong(String key) {
        return this.data.getLong(key);
    }

    public Double getDouble(String key) {
        return this.data.getDouble(key);
    }

    public Boolean getBoolean(String key) {
        return this.data.getBoolean(key);
    }

    public JSONList getList(String key) {
        return this.data.getList(key);
    }

    public JSONMap getMap(String key) {
        return this.data.getMap(key);
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public void clear() {
        this.data.clear();
    }

    public void set(String key, Object value) {
        this.manager.setModified(new ChunkPosition(this.block, this.world));
        if (value == null) {
            this.data.remove(key);
            return;
        }
        this.data.put(key, value);
    }

    public void remove(String key) {
        this.set(key, null);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Set<String> getKeys() {
        return this.data.keySet();
    }
}

