/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import redempt.redlib.config.data.DataHolder;
import redempt.redlib.config.data.MapDataHolder;

public class ListDataHolder
implements DataHolder {
    private List<Object> list;

    public ListDataHolder(List<?> list) {
        this.list = list;
    }

    public ListDataHolder() {
        this(new ArrayList());
    }

    @Override
    public Object get(String path) {
        int index = Integer.parseInt(path);
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return this.list.get(index);
    }

    @Override
    public void set(String path, Object obj) {
        int index = Integer.parseInt(path);
        obj = DataHolder.unwrap(obj);
        if (index >= this.list.size()) {
            this.list.add(obj);
        } else {
            this.list.set(index, obj);
        }
    }

    @Override
    public DataHolder getSubsection(String path) {
        Object obj = this.get(path);
        return obj instanceof Map ? new MapDataHolder((Map)obj) : null;
    }

    @Override
    public DataHolder createSubsection(String path) {
        int index = Integer.parseInt(path);
        MapDataHolder holder = new MapDataHolder();
        if (index >= this.list.size()) {
            this.list.add(holder.unwrap());
        } else {
            this.list.set(index, holder.unwrap());
        }
        return holder;
    }

    @Override
    public Set<String> getKeys() {
        return IntStream.range(0, this.list.size()).mapToObj(String::valueOf).collect(Collectors.toSet());
    }

    @Override
    public boolean isSet(String path) {
        int index = Integer.parseInt(path);
        return index > 0 && index < this.list.size();
    }

    @Override
    public String getString(String path) {
        Object val = this.get(path);
        return val == null ? null : String.valueOf(val);
    }

    @Override
    public DataHolder getList(String path) {
        Object obj = this.get(path);
        return obj instanceof List ? new ListDataHolder((List)obj) : null;
    }

    @Override
    public void remove(String path) {
        this.list.remove(Integer.parseInt(path));
    }

    @Override
    public Object unwrap() {
        return this.list;
    }
}

