/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import redempt.redlib.config.data.DataHolder;
import redempt.redlib.config.data.ListDataHolder;

public class ConfigurationSectionDataHolder
implements DataHolder {
    private ConfigurationSection section;
    private Map<String, List<String>> comments;

    public ConfigurationSectionDataHolder(ConfigurationSection section) {
        this(section, new HashMap<String, List<String>>());
    }

    private ConfigurationSectionDataHolder(ConfigurationSection section, Map<String, List<String>> comments) {
        this.section = section;
        this.comments = comments;
    }

    @Override
    public Object get(String path) {
        return this.section.get(path);
    }

    @Override
    public void set(String path, Object obj) {
        this.section.set(path, DataHolder.unwrap(obj));
    }

    @Override
    public DataHolder getSubsection(String path) {
        ConfigurationSection subsection = this.section.getConfigurationSection(path);
        return subsection == null ? null : new ConfigurationSectionDataHolder(subsection, this.comments);
    }

    @Override
    public DataHolder createSubsection(String path) {
        return new ConfigurationSectionDataHolder(this.section.createSection(path), this.comments);
    }

    @Override
    public Set<String> getKeys() {
        return this.section.getKeys(false);
    }

    @Override
    public boolean isSet(String path) {
        return this.section.isSet(path);
    }

    @Override
    public String getString(String path) {
        return this.section.getString(path);
    }

    @Override
    public DataHolder getList(String path) {
        return new ListDataHolder(this.section.getList(path));
    }

    @Override
    public void remove(String path) {
        this.section.set(path, null);
    }

    @Override
    public Object unwrap() {
        return this.section;
    }

    public void clearComments() {
        this.comments.clear();
    }

    public Map<String, List<String>> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String path, List<String> comments) {
        String currentPath = this.section.getCurrentPath();
        String key = currentPath == null || currentPath.equals(".") ? path : currentPath + "." + path;
        this.comments.put(key, comments);
    }
}

