/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import redempt.redlib.RedLib;
import redempt.redlib.misc.EventListener;
import redempt.redlib.region.Region;
import redempt.redlib.region.RegionMap;
import redempt.redlib.region.events.RegionEnterEvent;
import redempt.redlib.region.events.RegionExitEvent;

public class RegionEnterExitListener {
    private static RegionMap<Region> regionMap = new RegionMap();

    private static void register() {
        new EventListener<PlayerMoveEvent>(RedLib.getInstance(), PlayerMoveEvent.class, e -> {
            regionMap.get(e.getFrom()).forEach(r -> {
                if (r.contains(e.getFrom()) && !r.contains(e.getTo())) {
                    Bukkit.getPluginManager().callEvent((Event)new RegionExitEvent(e.getPlayer(), (Region)r, RegionExitEvent.ExitCause.MOVE, (Cancellable)e));
                }
            });
            regionMap.get(e.getTo()).forEach(r -> {
                if (!r.contains(e.getFrom()) && r.contains(e.getTo())) {
                    Bukkit.getPluginManager().callEvent((Event)new RegionEnterEvent(e.getPlayer(), (Region)r, RegionEnterEvent.EnterCause.MOVE, (Cancellable)e));
                }
            });
        });
        new EventListener<PlayerTeleportEvent>(RedLib.getInstance(), PlayerTeleportEvent.class, e -> {
            regionMap.get(e.getFrom()).forEach(r -> {
                if (r.contains(e.getFrom()) && !r.contains(e.getTo())) {
                    Bukkit.getPluginManager().callEvent((Event)new RegionExitEvent(e.getPlayer(), (Region)r, RegionExitEvent.ExitCause.TELEPORT, (Cancellable)e));
                }
            });
            regionMap.get(e.getTo()).forEach(r -> {
                if (!r.contains(e.getFrom()) && r.contains(e.getTo())) {
                    Bukkit.getPluginManager().callEvent((Event)new RegionEnterEvent(e.getPlayer(), (Region)r, RegionEnterEvent.EnterCause.TELEPORT, (Cancellable)e));
                }
            });
        });
        new EventListener<PlayerQuitEvent>(RedLib.getInstance(), PlayerQuitEvent.class, e -> regionMap.get(e.getPlayer().getLocation()).forEach(r -> {
            if (r.contains(e.getPlayer().getLocation())) {
                Bukkit.getPluginManager().callEvent((Event)new RegionExitEvent(e.getPlayer(), (Region)r, RegionExitEvent.ExitCause.QUIT, null));
            }
        }));
        new EventListener<PlayerJoinEvent>(RedLib.getInstance(), PlayerJoinEvent.class, e -> regionMap.get(e.getPlayer().getLocation()).forEach(r -> {
            if (r.contains(e.getPlayer().getLocation())) {
                Bukkit.getPluginManager().callEvent((Event)new RegionEnterEvent(e.getPlayer(), (Region)r, RegionEnterEvent.EnterCause.JOIN, null));
            }
        }));
        new EventListener<PlayerDeathEvent>(RedLib.getInstance(), PlayerDeathEvent.class, e -> regionMap.get(e.getEntity().getLocation()).forEach(r -> {
            if (r.contains(e.getEntity().getLocation())) {
                Bukkit.getPluginManager().callEvent((Event)new RegionExitEvent(e.getEntity(), (Region)r, RegionExitEvent.ExitCause.DEATH, null));
            }
        }));
        new EventListener<PlayerRespawnEvent>(RedLib.getInstance(), PlayerRespawnEvent.class, e -> regionMap.get(e.getPlayer().getLocation()).forEach(r -> {
            if (r.contains(e.getPlayer().getLocation())) {
                Bukkit.getPluginManager().callEvent((Event)new RegionEnterEvent(e.getPlayer(), (Region)r, RegionEnterEvent.EnterCause.RESPAWN, null));
            }
        }));
    }

    protected static RegionMap<Region> getRegionMap() {
        return regionMap;
    }

    static {
        RegionEnterExitListener.register();
    }
}

