/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata.backend;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.bukkit.block.Block;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.blockdata.ChunkPosition;
import redempt.redlib.blockdata.DataBlock;
import redempt.redlib.blockdata.backend.BlockDataBackend;
import redempt.redlib.json.JSONMap;
import redempt.redlib.json.JSONParser;
import redempt.redlib.misc.LocationUtils;
import redempt.redlib.sql.SQLHelper;

class SQLiteBackend
implements BlockDataBackend {
    private SQLHelper helper;
    private Executor exec = Executors.newSingleThreadExecutor();
    private Path path;

    public SQLiteBackend(Path path) {
        this.path = path;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.helper = new SQLHelper(SQLHelper.openSQLite(path));
        this.helper.execute("PRAGMA synchronous = OFF;", new Object[0]);
        this.helper.executeUpdate("CREATE TABLE IF NOT EXISTS data (x INT, z INT, world STRING, data TEXT, PRIMARY KEY (x, z, world));", new Object[0]);
        this.helper.setCommitInterval(6000);
    }

    @Override
    public boolean attemptMigration(BlockDataManager manager) {
        try {
            DatabaseMetaData metadata = this.helper.getConnection().getMetaData();
            ResultSet results = metadata.getTables(null, null, "blocks", null);
            if (!results.next()) {
                return false;
            }
            results.close();
            Files.copy(this.path, this.path.getParent().resolve(this.path.getFileName() + "_old"), StandardCopyOption.REPLACE_EXISTING);
            this.helper.queryResults("SELECT x, y, z, world, data FROM blocks;", new Object[0]).forEach(r -> {
                int x = (Integer)r.get(1);
                int y = (Integer)r.get(2);
                int z = (Integer)r.get(3);
                String worldName = r.getString(4);
                String data = r.getString(5);
                LocationUtils.waitForWorld(worldName, world -> {
                    Block block = world.getBlockAt(x, y, z);
                    DataBlock db = manager.getDataBlock(block);
                    JSONMap map = JSONParser.parseMap(data);
                    map.keySet().forEach(k -> db.set((String)k, map.get(k)));
                });
            });
            this.helper.executeUpdate("DROP TABLE blocks;", new Object[0]);
            manager.save();
            return true;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public CompletableFuture<String> load(ChunkPosition pos) {
        return CompletableFuture.supplyAsync(() -> this.helper.querySingleResultString("SELECT data FROM data WHERE x=? AND z=? AND world=?", pos.getX(), pos.getZ(), pos.getWorld().getName()), this.exec);
    }

    @Override
    public CompletableFuture<Void> save(ChunkPosition pos, String data) {
        return CompletableFuture.runAsync(() -> this.helper.executeUpdate("REPLACE INTO data VALUES (?, ?, ?, ?);", pos.getX(), pos.getZ(), pos.getWorld().getName(), data), this.exec);
    }

    @Override
    public CompletableFuture<Void> remove(ChunkPosition pos) {
        return CompletableFuture.runAsync(() -> this.helper.executeUpdate("DELETE FROM data WHERE x=? AND z=? AND world=?;", pos.getX(), pos.getZ(), pos.getWorld().getName()), this.exec);
    }

    @Override
    public CompletableFuture<Void> saveAll() {
        return CompletableFuture.runAsync(() -> this.helper.commit(), this.exec);
    }

    @Override
    public CompletableFuture<Void> close() {
        return CompletableFuture.runAsync(() -> {
            this.saveAll();
            this.helper.close();
        }, this.exec);
    }

    @Override
    public CompletableFuture<Map<ChunkPosition, String>> loadAll() {
        return CompletableFuture.supplyAsync(() -> {
            SQLHelper.Results results = this.helper.queryResults("SELECT * FROM data;", new Object[0]);
            HashMap map = new HashMap();
            results.forEach(r -> {
                int x = (Integer)r.get(1);
                int z = (Integer)r.get(2);
                String world = r.getString(3);
                ChunkPosition pos = new ChunkPosition(x, z, world);
                String data = r.getString(4);
                map.put(pos, data);
            });
            return map;
        }, this.exec);
    }
}

