/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata.backend;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.blockdata.ChunkPosition;
import redempt.redlib.blockdata.backend.BlockDataBackend;

class PDCBackend
implements BlockDataBackend {
    private NamespacedKey key;

    public PDCBackend(Plugin plugin) {
        this.key = new NamespacedKey(plugin, "blockData");
    }

    @Override
    public CompletableFuture<String> load(ChunkPosition pos) {
        PersistentDataContainer pdc = pos.getWorld().getChunkAt(pos.getX(), pos.getZ()).getPersistentDataContainer();
        return CompletableFuture.completedFuture((String)pdc.get(this.key, PersistentDataType.STRING));
    }

    @Override
    public CompletableFuture<Void> save(ChunkPosition pos, String data) {
        PersistentDataContainer pdc = pos.getWorld().getChunkAt(pos.getX(), pos.getZ()).getPersistentDataContainer();
        pdc.set(this.key, PersistentDataType.STRING, (Object)data);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> remove(ChunkPosition pos) {
        PersistentDataContainer pdc = pos.getWorld().getChunkAt(pos.getX(), pos.getZ()).getPersistentDataContainer();
        pdc.remove(this.key);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> saveAll() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Map<ChunkPosition, String>> loadAll() {
        throw new UnsupportedOperationException("PDC backend cannot access all data blocks");
    }

    @Override
    public boolean attemptMigration(BlockDataManager manager) {
        return false;
    }
}

