/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.multiblock;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import redempt.redlib.multiblock.MultiBlockStructure;
import redempt.redlib.multiblock.Rotator;
import redempt.redlib.multiblock.Structure;
import redempt.redlib.multiblock.StructureData;

class StructureFinder {
    private MultiBlockStructure type;
    private Map<Material, List<int[]>> materialMap = new HashMap<Material, List<int[]>>();
    private List<Material> materials = new ArrayList<Material>();

    public StructureFinder(MultiBlockStructure type) {
        this.type = type;
    }

    private void initializeMap() {
        for (int x = 0; x < this.type.dimX; ++x) {
            for (int y = 0; y < this.type.dimY; ++y) {
                int z = 0;
                while (z < this.type.dimZ) {
                    Material type = this.type.data[x][y][z].getType();
                    List<int[]> list = this.materialMap.get(type);
                    if (list == null) {
                        list = new ArrayList<int[]>();
                        this.materialMap.put(type, list);
                        this.materials.add(type);
                    }
                    list.add(new int[]{x, y, z++});
                }
            }
        }
        boolean air = this.materials.remove(Material.AIR);
        this.materials.sort(Comparator.comparingInt(m -> this.materialMap.get(m).size()));
        if (air) {
            this.materials.add(Material.AIR);
        }
    }

    public Structure getAt(Block block) {
        List<int[]> locations;
        if (this.materialMap.size() == 0) {
            this.initializeMap();
        }
        if ((locations = this.materialMap.get(block.getType())) == null) {
            if (!this.type.ignoreAir) {
                return null;
            }
            locations = this.materialMap.get(Material.AIR);
            if (locations == null) {
                return null;
            }
        }
        Rotator rotator = new Rotator(1, false);
        for (int rot = 0; rot < 4; ++rot) {
            for (int mirror = 0; mirror < 2; ++mirror) {
                rotator.setRotation(rot);
                rotator.setMirrored(mirror == 1);
                Structure struct = this.getAt(block, rotator);
                if (struct == null) continue;
                return struct;
            }
        }
        return null;
    }

    private Structure getAt(Block block, Rotator rotator) {
        int maxX = this.type.dimX;
        int maxY = this.type.dimY;
        int maxZ = this.type.dimZ;
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                boolean foundY = false;
                for (int z = 0; z < maxZ; ++z) {
                    rotator.setLocation(x, z);
                    Block b = block.getRelative(-rotator.getRotatedBlockX(), -y, -rotator.getRotatedBlockZ());
                    if (!this.type.ignoreAir && !this.materialMap.containsKey(b.getType())) {
                        if (!foundY) break;
                        maxZ = z;
                        break;
                    }
                    foundY = true;
                    Structure struct = this.getExact(b, rotator);
                    if (struct == null) continue;
                    return struct;
                }
                if (foundY) continue;
                maxY = y;
            }
        }
        return null;
    }

    private Structure getExact(Block block, Rotator rotator) {
        for (Material mat : this.materials) {
            List<int[]> instances = this.materialMap.get(mat);
            for (int[] pos : instances) {
                StructureData data = this.type.data[pos[0]][pos[1]][pos[2]];
                rotator.setLocation(pos[0], pos[2]);
                Block b = block.getRelative(rotator.getRotatedBlockX(), pos[1], rotator.getRotatedBlockZ());
                if (this.type.compare(data, b, rotator)) continue;
                return null;
            }
        }
        return new Structure(this.type, block.getLocation(), rotator);
    }
}

