/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.json;

import redempt.redlib.json.JSONList;
import redempt.redlib.json.JSONMap;

public class JSONParser {
    private static boolean[] whitespace = new boolean[256];
    private int pos;
    private String str;
    private StringBuilder builder = new StringBuilder();

    public static String toJSONString(Object o) {
        return o instanceof String ? '\"' + ((String)o).replace("\\", "\\\\").replace("\"", "\\\"") + '\"' : o.toString();
    }

    public static JSONMap parseMap(String json) {
        return new JSONParser(json).map();
    }

    public static JSONList parseList(String json) {
        return new JSONParser(json).list();
    }

    private JSONParser(String str) {
        this.str = str;
    }

    private char peek() {
        return this.str.charAt(this.pos);
    }

    private char advance() {
        return this.str.charAt(this.pos++);
    }

    private void assertChar(char c) {
        if (this.advance() != c) {
            throw new IllegalArgumentException("Invalid JSON, expected '" + c + "' at position " + (this.pos - 1));
        }
    }

    private boolean isWhitespace() {
        char c = this.peek();
        return c < '\u0100' && whitespace[c];
    }

    private boolean isDigit() {
        return Character.isDigit(this.peek());
    }

    private void whitespace() {
        while (this.isWhitespace()) {
            ++this.pos;
        }
    }

    private long integer() {
        boolean negative;
        boolean bl = negative = this.peek() == '-';
        if (negative) {
            ++this.pos;
        }
        int out = 0;
        while (this.isDigit()) {
            out *= 10;
            out += this.advance() - 48;
        }
        return negative ? (long)(-out) : (long)out;
    }

    private double decimal(long first) {
        this.assertChar('.');
        long second = this.integer();
        double decimal = (double)second * Math.pow(0.1, Math.ceil(Math.log10(second)));
        return decimal + (double)first;
    }

    private char escapeSequence() {
        switch (this.advance()) {
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'u': {
                return (char)Integer.parseInt(this.str.substring(this.pos, this.pos + 4), 16);
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
        }
        throw new IllegalArgumentException("Invalid escape sequence at position " + this.pos);
    }

    private String string() {
        char c;
        this.assertChar('\"');
        this.builder.setLength(0);
        while ((c = this.advance()) != '\"') {
            this.builder.append(c == '\\' ? this.escapeSequence() : c);
        }
        return this.builder.toString();
    }

    private Object object() {
        switch (this.peek()) {
            case 't': {
                this.pos += 4;
                return true;
            }
            case 'f': {
                this.pos += 5;
                return false;
            }
            case 'n': {
                this.pos += 4;
                return null;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                long num = this.integer();
                if (this.peek() == '.') {
                    return this.decimal(num);
                }
                return num;
            }
            case '.': {
                return this.decimal(0L);
            }
            case '\"': {
                return this.string();
            }
            case '[': {
                return this.list();
            }
            case '{': {
                return this.map();
            }
        }
        throw new IllegalArgumentException("Invalid JSON, unknown token at position " + this.pos);
    }

    private JSONList list() {
        this.assertChar('[');
        this.whitespace();
        JSONList list = new JSONList();
        while (this.peek() != ']') {
            list.add(this.object());
            this.whitespace();
            if (this.peek() != ',') continue;
            ++this.pos;
            this.whitespace();
        }
        ++this.pos;
        return list;
    }

    private JSONMap map() {
        this.assertChar('{');
        this.whitespace();
        JSONMap map = new JSONMap();
        while (this.peek() != '}') {
            String key = this.string();
            this.whitespace();
            this.assertChar(':');
            this.whitespace();
            map.put(key, this.object());
            if (this.peek() != ',') continue;
            ++this.pos;
            this.whitespace();
        }
        ++this.pos;
        return map;
    }

    static {
        JSONParser.whitespace[32] = true;
        JSONParser.whitespace[10] = true;
        JSONParser.whitespace[9] = true;
    }
}

