/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.enchants.trigger;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import redempt.redlib.enchants.EventItems;
import redempt.redlib.enchants.events.PlayerChangedArmorEvent;
import redempt.redlib.enchants.events.PlayerChangedHeldItemEvent;
import redempt.redlib.enchants.trigger.AttackEntityTrigger;
import redempt.redlib.enchants.trigger.EquipArmorTrigger;
import redempt.redlib.enchants.trigger.HoldItemTrigger;
import redempt.redlib.enchants.trigger.KillEntityTrigger;
import redempt.redlib.enchants.trigger.MineBlockTrigger;
import redempt.redlib.enchants.trigger.ShootArrowTrigger;
import redempt.redlib.enchants.trigger.TakeDamageTrigger;

public abstract class EnchantTrigger<T extends Event> {
    public static final EnchantTrigger<BlockBreakEvent> MINE_BLOCK = new MineBlockTrigger();
    public static final EnchantTrigger<EntityDamageByEntityEvent> ATTACK_ENTITY = new AttackEntityTrigger();
    public static final EnchantTrigger<EntityDeathEvent> KILL_ENTITY = new KillEntityTrigger();
    public static final EnchantTrigger<ProjectileLaunchEvent> SHOOT_ARROW = new ShootArrowTrigger();
    public static final EnchantTrigger<EntityDamageEvent> TAKE_DAMAGE = new TakeDamageTrigger();
    public static final EnchantTrigger<PlayerChangedArmorEvent> EQUIP_ARMOR = new EquipArmorTrigger();
    public static final EnchantTrigger<PlayerChangedHeldItemEvent> HOLD_ITEM = new HoldItemTrigger();
    protected Map<Class<? extends Event>, Function<Event, EventItems>> events = new HashMap<Class<? extends Event>, Function<Event, EventItems>>();

    protected abstract void register();

    public final void init() {
        this.events.clear();
        this.register();
    }

    protected <T extends Event> void addListener(Class<T> eventClass, Function<T, EventItems> func) {
        this.events.put(eventClass, func);
    }

    public Map<Class<? extends Event>, Function<Event, EventItems>> getEvents() {
        return this.events;
    }

    public EventPriority getPriority() {
        return EventPriority.NORMAL;
    }

    public abstract boolean defaultAppliesTo(Material var1);

    public EnchantTrigger<T> withPriority(final EventPriority priority) {
        final Predicate<Material> appliesTo = this::defaultAppliesTo;
        final Map<Class<? extends Event>, Function<Event, EventItems>> eventMap = this.events;
        final Runnable register = () -> {
            if (this.events.isEmpty()) {
                this.register();
            }
        };
        return new EnchantTrigger<T>(){

            @Override
            protected void register() {
                register.run();
                this.events = eventMap;
            }

            @Override
            public boolean defaultAppliesTo(Material type) {
                return appliesTo.test(type);
            }

            @Override
            public EventPriority getPriority() {
                return priority;
            }
        };
    }
}

